exports.id=556,exports.ids=[556],exports.modules={84878:(e,t)=>{"use strict";function getDeploymentIdQueryOrEmptyString(){return""}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getDeploymentIdQueryOrEmptyString",{enumerable:!0,get:function(){return getDeploymentIdQueryOrEmptyString}})},95498:(e,t,r)=>{"use strict";var n;r.d(t,{Q0:()=>n,X0:()=>getVersionUpgrade,fK:()=>a});let a=JSON.parse('{"$schema":"http://json-schema.org/draft-07/schema#","$id":"https://uniswap.org/tokenlist.schema.json","title":"Uniswap Token List","description":"Schema for lists of tokens compatible with the Uniswap Interface","definitions":{"Version":{"type":"object","description":"The version of the list, used in change detection","examples":[{"major":1,"minor":0,"patch":0}],"additionalProperties":false,"properties":{"major":{"type":"integer","description":"The major version of the list. Must be incremented when tokens are removed from the list or token addresses are changed.","minimum":0,"examples":[1,2]},"minor":{"type":"integer","description":"The minor version of the list. Must be incremented when tokens are added to the list.","minimum":0,"examples":[0,1]},"patch":{"type":"integer","description":"The patch version of the list. Must be incremented for any changes to the list.","minimum":0,"examples":[0,1]}},"required":["major","minor","patch"]},"TagIdentifier":{"type":"string","description":"The unique identifier of a tag","minLength":1,"maxLength":10,"pattern":"^[\\\\w]+$","examples":["compound","stablecoin"]},"ExtensionIdentifier":{"type":"string","description":"The name of a token extension property","minLength":1,"maxLength":40,"pattern":"^[\\\\w]+$","examples":["color","is_fee_on_transfer","aliases"]},"ExtensionMap":{"type":"object","description":"An object containing any arbitrary or vendor-specific token metadata","maxProperties":10,"propertyNames":{"$ref":"#/definitions/ExtensionIdentifier"},"additionalProperties":{"$ref":"#/definitions/ExtensionValue"},"examples":[{"color":"#000000","is_verified_by_me":true},{"x-bridged-addresses-by-chain":{"1":{"bridgeAddress":"0x4200000000000000000000000000000000000010","tokenAddress":"0x4200000000000000000000000000000000000010"}}}]},"ExtensionPrimitiveValue":{"anyOf":[{"type":"string","minLength":1,"maxLength":42,"examples":["#00000"]},{"type":"boolean","examples":[true]},{"type":"number","examples":[15]},{"type":"null"}]},"ExtensionValue":{"anyOf":[{"$ref":"#/definitions/ExtensionPrimitiveValue"},{"type":"object","maxProperties":10,"propertyNames":{"$ref":"#/definitions/ExtensionIdentifier"},"additionalProperties":{"$ref":"#/definitions/ExtensionValueInner0"}}]},"ExtensionValueInner0":{"anyOf":[{"$ref":"#/definitions/ExtensionPrimitiveValue"},{"type":"object","maxProperties":10,"propertyNames":{"$ref":"#/definitions/ExtensionIdentifier"},"additionalProperties":{"$ref":"#/definitions/ExtensionValueInner1"}}]},"ExtensionValueInner1":{"anyOf":[{"$ref":"#/definitions/ExtensionPrimitiveValue"}]},"TagDefinition":{"type":"object","description":"Definition of a tag that can be associated with a token via its identifier","additionalProperties":false,"properties":{"name":{"type":"string","description":"The name of the tag","pattern":"^[ \\\\w]+$","minLength":1,"maxLength":20},"description":{"type":"string","description":"A user-friendly description of the tag","pattern":"^[ \\\\w\\\\.,:]+$","minLength":1,"maxLength":200}},"required":["name","description"],"examples":[{"name":"Stablecoin","description":"A token with value pegged to another asset"}]},"TokenInfo":{"type":"object","description":"Metadata for a single token in a token list","additionalProperties":false,"properties":{"chainId":{"type":"integer","description":"The chain ID of the Ethereum network where this token is deployed","minimum":1,"examples":[1,42]},"address":{"type":"string","description":"The checksummed address of the token on the specified chain ID","pattern":"^(0x[a-fA-F0-9]{40}|[1-9A-HJ-NP-Za-km-z]{32,44})$","examples":["0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48","So11111111111111111111111111111111111111112"]},"decimals":{"type":"integer","description":"The number of decimals for the token balance","minimum":0,"maximum":255,"examples":[18]},"name":{"type":"string","description":"The name of the token","minLength":0,"maxLength":60,"anyOf":[{"const":""},{"pattern":"^[ \\\\S+]+$"}],"examples":["USD Coin"]},"symbol":{"type":"string","description":"The symbol for the token","minLength":0,"maxLength":20,"anyOf":[{"const":""},{"pattern":"^\\\\S+$"}],"examples":["USDC"]},"logoURI":{"type":"string","description":"A URI to the token logo asset; if not set, interface will attempt to find a logo based on the token address; suggest SVG or PNG of size 64x64","format":"uri","examples":["ipfs://QmXfzKRvjZz3u5JRgC4v5mGVbm9ahrUiB4DgzHBsnWbTMM"]},"tags":{"type":"array","description":"An array of tag identifiers associated with the token; tags are defined at the list level","items":{"$ref":"#/definitions/TagIdentifier"},"maxItems":10,"examples":["stablecoin","compound"]},"extensions":{"$ref":"#/definitions/ExtensionMap"}},"required":["chainId","address","decimals","name","symbol"]}},"type":"object","properties":{"name":{"type":"string","description":"The name of the token list","minLength":1,"maxLength":30,"pattern":"^[\\\\w ]+$","examples":["My Token List"]},"timestamp":{"type":"string","format":"date-time","description":"The timestamp of this list version; i.e. when this immutable version of the list was created"},"version":{"$ref":"#/definitions/Version"},"tokens":{"type":"array","description":"The list of tokens included in the list","items":{"$ref":"#/definitions/TokenInfo"},"minItems":1,"maxItems":10000},"tokenMap":{"type":"object","description":"A mapping of key \'chainId_tokenAddress\' to its corresponding token object","minProperties":1,"maxProperties":10000,"propertyNames":{"type":"string"},"additionalProperties":{"$ref":"#/definitions/TokenInfo"},"examples":[{"4_0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984":{"name":"Uniswap","address":"0x1f9840a85d5aF5bf1D1762F925BDADdC4201F984","symbol":"UNI","decimals":18,"chainId":4,"logoURI":"ipfs://QmXttGpZrECX5qCyXbBQiqgQNytVGeZW5Anewvh2jc4psg"}}]},"keywords":{"type":"array","description":"Keywords associated with the contents of the list; may be used in list discoverability","items":{"type":"string","description":"A keyword to describe the contents of the list","minLength":1,"maxLength":20,"pattern":"^[\\\\w ]+$","examples":["compound","lending","personal tokens"]},"maxItems":20,"uniqueItems":true},"tags":{"type":"object","description":"A mapping of tag identifiers to their name and description","propertyNames":{"$ref":"#/definitions/TagIdentifier"},"additionalProperties":{"$ref":"#/definitions/TagDefinition"},"maxProperties":20,"examples":[{"stablecoin":{"name":"Stablecoin","description":"A token with value pegged to another asset"}}]},"logoURI":{"type":"string","description":"A URI for the logo of the token list; prefer SVG or PNG of size 256x256","format":"uri","examples":["ipfs://QmXfzKRvjZz3u5JRgC4v5mGVbm9ahrUiB4DgzHBsnWbTMM"]}},"required":["name","timestamp","version","tokens"]}');function getVersionUpgrade(e,t){return t.major>e.major?3:t.major<e.major?0:t.minor>e.minor?2:t.minor<e.minor?0:t.patch>e.patch?1:0}!function(e){e[e.NONE=0]="NONE",e[e.PATCH=1]="PATCH",e[e.MINOR=2]="MINOR",e[e.MAJOR=3]="MAJOR"}(n||(n={}))},68187:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"addBasePath",{enumerable:!0,get:function(){return addBasePath}});let n=r(36033),a=r(87174);function addBasePath(e,t){return(0,a.normalizePathTrailingSlash)((0,n.addPathPrefix)(e,""))}("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},77836:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"addLocale",{enumerable:!0,get:function(){return addLocale}}),r(87174);let addLocale=function(e){for(var t=arguments.length,r=Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];return e};("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},85107:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{RSC:function(){return r},ACTION:function(){return n},NEXT_ROUTER_STATE_TREE:function(){return a},NEXT_ROUTER_PREFETCH:function(){return o},NEXT_URL:function(){return i},RSC_CONTENT_TYPE_HEADER:function(){return s},RSC_VARY_HEADER:function(){return l},FLIGHT_PARAMETERS:function(){return u},NEXT_RSC_UNION_QUERY:function(){return c}});let r="RSC",n="Next-Action",a="Next-Router-State-Tree",o="Next-Router-Prefetch",i="Next-Url",s="text/x-component",l=r+", "+a+", "+o+", "+i,u=[[r],[a],[o]],c="_rsc";("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},82457:(e,t)=>{"use strict";var r;Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{PrefetchKind:function(){return r},ACTION_REFRESH:function(){return n},ACTION_NAVIGATE:function(){return a},ACTION_RESTORE:function(){return o},ACTION_SERVER_PATCH:function(){return i},ACTION_PREFETCH:function(){return s},ACTION_FAST_REFRESH:function(){return l},ACTION_SERVER_ACTION:function(){return u}});let n="refresh",a="navigate",o="restore",i="server-patch",s="prefetch",l="fast-refresh",u="server-action";(function(e){e.AUTO="auto",e.FULL="full",e.TEMPORARY="temporary"})(r||(r={})),("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},68275:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"detectDomainLocale",{enumerable:!0,get:function(){return detectDomainLocale}});let detectDomainLocale=function(){for(var e=arguments.length,t=Array(e),r=0;r<e;r++)t[r]=arguments[r]};("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},97825:(e,t,r)=>{"use strict";function getDomainLocale(e,t,r,n){return!1}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getDomainLocale",{enumerable:!0,get:function(){return getDomainLocale}}),r(87174),("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},17361:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"hasBasePath",{enumerable:!0,get:function(){return hasBasePath}});let n=r(30619);function hasBasePath(e){return(0,n.pathHasPrefix)(e,"")}("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},70604:(e,t)=>{"use strict";let r;Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{DOMAttributeNames:function(){return n},isEqualNode:function(){return isEqualNode},default:function(){return initHeadManager}});let n={acceptCharset:"accept-charset",className:"class",htmlFor:"for",httpEquiv:"http-equiv",noModule:"noModule"};function reactElementToDOM(e){let{type:t,props:r}=e,a=document.createElement(t);for(let e in r){if(!r.hasOwnProperty(e)||"children"===e||"dangerouslySetInnerHTML"===e||void 0===r[e])continue;let o=n[e]||e.toLowerCase();"script"===t&&("async"===o||"defer"===o||"noModule"===o)?a[o]=!!r[e]:a.setAttribute(o,r[e])}let{children:o,dangerouslySetInnerHTML:i}=r;return i?a.innerHTML=i.__html||"":o&&(a.textContent="string"==typeof o?o:Array.isArray(o)?o.join(""):""),a}function isEqualNode(e,t){if(e instanceof HTMLElement&&t instanceof HTMLElement){let r=t.getAttribute("nonce");if(r&&!e.getAttribute("nonce")){let n=t.cloneNode(!0);return n.setAttribute("nonce",""),n.nonce=r,r===e.nonce&&e.isEqualNode(n)}}return e.isEqualNode(t)}function initHeadManager(){return{mountedInstances:new Set,updateHead:e=>{let t={};e.forEach(e=>{if("link"===e.type&&e.props["data-optimized-fonts"]){if(document.querySelector('style[data-href="'+e.props["data-href"]+'"]'))return;e.props.href=e.props["data-href"],e.props["data-href"]=void 0}let r=t[e.type]||[];r.push(e),t[e.type]=r});let n=t.title?t.title[0]:null,a="";if(n){let{children:e}=n.props;a="string"==typeof e?e:Array.isArray(e)?e.join(""):""}a!==document.title&&(document.title=a),["meta","base","link","style","script"].forEach(e=>{r(e,t[e]||[])})}}}r=(e,t)=>{let r=document.getElementsByTagName("head")[0],n=r.querySelector("meta[name=next-head-count]"),a=Number(n.content),o=[];for(let t=0,r=n.previousElementSibling;t<a;t++,r=(null==r?void 0:r.previousElementSibling)||null){var i;(null==r?void 0:null==(i=r.tagName)?void 0:i.toLowerCase())===e&&o.push(r)}let s=t.map(reactElementToDOM).filter(e=>{for(let t=0,r=o.length;t<r;t++){let r=o[t];if(isEqualNode(r,e))return o.splice(t,1),!1}return!0});o.forEach(e=>{var t;return null==(t=e.parentNode)?void 0:t.removeChild(e)}),s.forEach(e=>r.insertBefore(e,n)),n.content=(a-o.length+s.length).toString()},("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},71923:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"Image",{enumerable:!0,get:function(){return m}});let n=r(50167),a=r(28760),o=a._(r(16689)),i=n._(r(66405)),s=n._(r(80636)),l=r(45803),u=r(29175),c=r(16218);r(74330);let d=r(5469),f=n._(r(41986)),p={deviceSizes:[640,750,828,1080,1200,1920,2048,3840],imageSizes:[16,32,48,64,96,128,256,384],path:"/_next/image/",loader:"default",dangerouslyAllowSVG:!1,unoptimized:!0};function handleLoading(e,t,r,n,a,o){let i=null==e?void 0:e.src;if(!e||e["data-loaded-src"]===i)return;e["data-loaded-src"]=i;let s="decode"in e?e.decode():Promise.resolve();s.catch(()=>{}).then(()=>{if(e.parentElement&&e.isConnected){if("empty"!==t&&a(!0),null==r?void 0:r.current){let t=new Event("load");Object.defineProperty(t,"target",{writable:!1,value:e});let n=!1,a=!1;r.current({...t,nativeEvent:t,currentTarget:e,target:e,isDefaultPrevented:()=>n,isPropagationStopped:()=>a,persist:()=>{},preventDefault:()=>{n=!0,t.preventDefault()},stopPropagation:()=>{a=!0,t.stopPropagation()}})}(null==n?void 0:n.current)&&n.current(e)}})}function getDynamicProps(e){let[t,r]=o.version.split("."),n=parseInt(t,10),a=parseInt(r,10);return n>18||18===n&&a>=3?{fetchPriority:e}:{fetchpriority:e}}globalThis.__NEXT_IMAGE_IMPORTED=!0;let h=(0,o.forwardRef)((e,t)=>{let{src:r,srcSet:n,sizes:a,height:i,width:s,decoding:l,className:u,style:c,fetchPriority:d,placeholder:f,loading:p,unoptimized:h,fill:m,onLoadRef:g,onLoadingCompleteRef:y,setBlurComplete:v,setShowAltText:_,onLoad:b,onError:P,...x}=e;return o.default.createElement("img",{...x,...getDynamicProps(d),loading:p,width:s,height:i,decoding:l,"data-nimg":m?"fill":"1",className:u,style:c,sizes:a,srcSet:n,src:r,ref:(0,o.useCallback)(e=>{t&&("function"==typeof t?t(e):"object"==typeof t&&(t.current=e)),e&&(P&&(e.src=e.src),e.complete&&handleLoading(e,f,g,y,v,h))},[r,f,g,y,v,P,h,t]),onLoad:e=>{let t=e.currentTarget;handleLoading(t,f,g,y,v,h)},onError:e=>{_(!0),"empty"!==f&&v(!0),P&&P(e)}})});function ImagePreload(e){let{isAppRouter:t,imgAttributes:r}=e,n={as:"image",imageSrcSet:r.srcSet,imageSizes:r.sizes,crossOrigin:r.crossOrigin,referrerPolicy:r.referrerPolicy,...getDynamicProps(r.fetchPriority)};return t&&i.default.preload?(i.default.preload(r.src,n),null):o.default.createElement(s.default,null,o.default.createElement("link",{key:"__nimg-"+r.src+r.srcSet+r.sizes,rel:"preload",href:r.srcSet?void 0:r.src,...n}))}let m=(0,o.forwardRef)((e,t)=>{let r=(0,o.useContext)(d.RouterContext),n=(0,o.useContext)(c.ImageConfigContext),a=(0,o.useMemo)(()=>{let e=p||n||u.imageConfigDefault,t=[...e.deviceSizes,...e.imageSizes].sort((e,t)=>e-t),r=e.deviceSizes.sort((e,t)=>e-t);return{...e,allSizes:t,deviceSizes:r}},[n]),{onLoad:i,onLoadingComplete:s}=e,m=(0,o.useRef)(i);(0,o.useEffect)(()=>{m.current=i},[i]);let g=(0,o.useRef)(s);(0,o.useEffect)(()=>{g.current=s},[s]);let[y,v]=(0,o.useState)(!1),[_,b]=(0,o.useState)(!1),{props:P,meta:x}=(0,l.getImgProps)(e,{defaultLoader:f.default,imgConf:a,blurComplete:y,showAltText:_});return o.default.createElement(o.default.Fragment,null,o.default.createElement(h,{...P,unoptimized:x.unoptimized,placeholder:x.placeholder,fill:x.fill,onLoadRef:m,onLoadingCompleteRef:g,setBlurComplete:v,setShowAltText:b,ref:t}),x.priority?o.default.createElement(ImagePreload,{isAppRouter:!r,imgAttributes:P}):null)});("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},49961:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"default",{enumerable:!0,get:function(){return y}});let n=r(50167),a=n._(r(16689)),o=r(28156),i=r(97106),s=r(33512),l=r(35504),u=r(77836),c=r(5469),d=r(7443),f=r(54714),p=r(97825),h=r(68187),m=r(82457);function formatStringOrUrl(e){return"string"==typeof e?e:(0,s.formatUrl)(e)}let g=a.default.forwardRef(function(e,t){let r,n;let{href:s,as:g,children:y,prefetch:v=null,passHref:_,replace:b,shallow:P,scroll:x,locale:R,onClick:S,onMouseEnter:w,onTouchStart:E,legacyBehavior:O=!1,...j}=e;r=y,O&&("string"==typeof r||"number"==typeof r)&&(r=a.default.createElement("a",null,r));let C=a.default.useContext(c.RouterContext),A=a.default.useContext(d.AppRouterContext),M=null!=C?C:A,T=!C,I=!1!==v,L=null===v?m.PrefetchKind.AUTO:m.PrefetchKind.FULL,{href:k,as:N}=a.default.useMemo(()=>{if(!C){let e=formatStringOrUrl(s);return{href:e,as:g?formatStringOrUrl(g):e}}let[e,t]=(0,o.resolveHref)(C,s,!0);return{href:e,as:g?(0,o.resolveHref)(C,g):t||e}},[C,s,g]),D=a.default.useRef(k),U=a.default.useRef(N);O&&(n=a.default.Children.only(r));let H=O?n&&"object"==typeof n&&n.ref:t,[B,F,z]=(0,f.useIntersection)({rootMargin:"200px"}),q=a.default.useCallback(e=>{(U.current!==N||D.current!==k)&&(z(),U.current=N,D.current=k),B(e),H&&("function"==typeof H?H(e):"object"==typeof H&&(H.current=e))},[N,H,k,z,B]);a.default.useEffect(()=>{},[N,k,F,R,I,null==C?void 0:C.locale,M,T,L]);let W={ref:q,onClick(e){O||"function"!=typeof S||S(e),O&&n.props&&"function"==typeof n.props.onClick&&n.props.onClick(e),M&&!e.defaultPrevented&&function(e,t,r,n,o,s,l,u,c,d){let{nodeName:f}=e.currentTarget,p="A"===f.toUpperCase();if(p&&(function(e){let t=e.currentTarget,r=t.getAttribute("target");return r&&"_self"!==r||e.metaKey||e.ctrlKey||e.shiftKey||e.altKey||e.nativeEvent&&2===e.nativeEvent.which}(e)||!c&&!(0,i.isLocalURL)(r)))return;e.preventDefault();let navigate=()=>{let e=null==l||l;"beforePopState"in t?t[o?"replace":"push"](r,n,{shallow:s,locale:u,scroll:e}):t[o?"replace":"push"](n||r,{forceOptimisticNavigation:!d,scroll:e})};c?a.default.startTransition(navigate):navigate()}(e,M,k,N,b,P,x,R,T,I)},onMouseEnter(e){O||"function"!=typeof w||w(e),O&&n.props&&"function"==typeof n.props.onMouseEnter&&n.props.onMouseEnter(e)},onTouchStart(e){O||"function"!=typeof E||E(e),O&&n.props&&"function"==typeof n.props.onTouchStart&&n.props.onTouchStart(e)}};if((0,l.isAbsoluteUrl)(N))W.href=N;else if(!O||_||"a"===n.type&&!("href"in n.props)){let e=void 0!==R?R:null==C?void 0:C.locale,t=(null==C?void 0:C.isLocaleDomain)&&(0,p.getDomainLocale)(N,e,null==C?void 0:C.locales,null==C?void 0:C.domainLocales);W.href=t||(0,h.addBasePath)((0,u.addLocale)(N,e,null==C?void 0:C.defaultLocale))}return O?a.default.cloneElement(n,W):a.default.createElement("a",{...j,...W},r)}),y=g;("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},87174:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"normalizePathTrailingSlash",{enumerable:!0,get:function(){return normalizePathTrailingSlash}});let n=r(84318),a=r(55017),normalizePathTrailingSlash=e=>{if(!e.startsWith("/"))return e;let{pathname:t,query:r,hash:o}=(0,a.parsePath)(e);return/\.[^/]+\/?$/.test(t)?""+(0,n.removeTrailingSlash)(t)+r+o:t.endsWith("/")?""+t+r+o:t+"/"+r+o};("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},83698:(e,t,r)=>{"use strict";function removeBasePath(e){return e}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"removeBasePath",{enumerable:!0,get:function(){return removeBasePath}}),r(17361),("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},36709:(e,t,r)=>{"use strict";function removeLocale(e,t){return e}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"removeLocale",{enumerable:!0,get:function(){return removeLocale}}),r(55017),("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},75787:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{requestIdleCallback:function(){return r},cancelIdleCallback:function(){return n}});let r="undefined"!=typeof self&&self.requestIdleCallback&&self.requestIdleCallback.bind(window)||function(e){let t=Date.now();return self.setTimeout(function(){e({didTimeout:!1,timeRemaining:function(){return Math.max(0,50-(Date.now()-t))}})},1)},n="undefined"!=typeof self&&self.cancelIdleCallback&&self.cancelIdleCallback.bind(window)||function(e){return clearTimeout(e)};("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},28156:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"resolveHref",{enumerable:!0,get:function(){return resolveHref}});let n=r(57655),a=r(33512),o=r(2954),i=r(35504),s=r(87174),l=r(97106),u=r(4350),c=r(50584);function resolveHref(e,t,r){let d;let f="string"==typeof t?t:(0,a.formatWithValidation)(t),p=f.match(/^[a-zA-Z]{1,}:\/\//),h=p?f.slice(p[0].length):f,m=h.split("?");if((m[0]||"").match(/(\/\/|\\)/)){console.error("Invalid href '"+f+"' passed to next/router in page: '"+e.pathname+"'. Repeated forward-slashes (//) or backslashes \\ are not valid in the href.");let t=(0,i.normalizeRepeatedSlashes)(h);f=(p?p[0]:"")+t}if(!(0,l.isLocalURL)(f))return r?[f]:f;try{d=new URL(f.startsWith("#")?e.asPath:e.pathname,"http://n")}catch(e){d=new URL("/","http://n")}try{let e=new URL(f,d);e.pathname=(0,s.normalizePathTrailingSlash)(e.pathname);let t="";if((0,u.isDynamicRoute)(e.pathname)&&e.searchParams&&r){let r=(0,n.searchParamsToUrlQuery)(e.searchParams),{result:i,params:s}=(0,c.interpolateAs)(e.pathname,e.pathname,r);i&&(t=(0,a.formatWithValidation)({pathname:i,hash:e.hash,query:(0,o.omit)(r,s)}))}let i=e.origin===d.origin?e.href.slice(e.origin.length):e.href;return r?[i,t||i]:i}catch(e){return r?[f]:f}}("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},94107:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{markAssetError:function(){return markAssetError},isAssetError:function(){return isAssetError},getClientBuildManifest:function(){return getClientBuildManifest},createRouteLoader:function(){return createRouteLoader}}),r(50167),r(83654);let n=r(41195),a=r(75787),o=r(84878);function withFuture(e,t,r){let n,a=t.get(e);if(a)return"future"in a?a.future:Promise.resolve(a);let o=new Promise(e=>{n=e});return t.set(e,a={resolve:n,future:o}),r?r().then(e=>(n(e),e)).catch(r=>{throw t.delete(e),r}):o}let i=Symbol("ASSET_LOAD_ERROR");function markAssetError(e){return Object.defineProperty(e,i,{})}function isAssetError(e){return e&&i in e}let s=function(e){try{return e=document.createElement("link"),!!window.MSInputMethodContext&&!!document.documentMode||e.relList.supports("prefetch")}catch(e){return!1}}(),getAssetQueryString=()=>(0,o.getDeploymentIdQueryOrEmptyString)();function resolvePromiseWithTimeout(e,t,r){return new Promise((n,o)=>{let i=!1;e.then(e=>{i=!0,n(e)}).catch(o),(0,a.requestIdleCallback)(()=>setTimeout(()=>{i||o(r)},t))})}function getClientBuildManifest(){if(self.__BUILD_MANIFEST)return Promise.resolve(self.__BUILD_MANIFEST);let e=new Promise(e=>{let t=self.__BUILD_MANIFEST_CB;self.__BUILD_MANIFEST_CB=()=>{e(self.__BUILD_MANIFEST),t&&t()}});return resolvePromiseWithTimeout(e,3800,markAssetError(Error("Failed to load client build manifest")))}function getFilesForRoute(e,t){return getClientBuildManifest().then(r=>{if(!(t in r))throw markAssetError(Error("Failed to lookup route: "+t));let a=r[t].map(t=>e+"/_next/"+encodeURI(t));return{scripts:a.filter(e=>e.endsWith(".js")).map(e=>(0,n.__unsafeCreateTrustedScriptURL)(e)+getAssetQueryString()),css:a.filter(e=>e.endsWith(".css")).map(e=>e+getAssetQueryString())}})}function createRouteLoader(e){let t=new Map,r=new Map,n=new Map,o=new Map;function maybeExecuteScript(e){{var t;let n=r.get(e.toString());return n||(document.querySelector('script[src^="'+e+'"]')?Promise.resolve():(r.set(e.toString(),n=new Promise((r,n)=>{(t=document.createElement("script")).onload=r,t.onerror=()=>n(markAssetError(Error("Failed to load script: "+e))),t.crossOrigin=void 0,t.src=e,document.body.appendChild(t)})),n))}}function fetchStyleSheet(e){let t=n.get(e);return t||n.set(e,t=fetch(e).then(t=>{if(!t.ok)throw Error("Failed to load stylesheet: "+e);return t.text().then(t=>({href:e,content:t}))}).catch(e=>{throw markAssetError(e)})),t}return{whenEntrypoint:e=>withFuture(e,t),onEntrypoint(e,r){(r?Promise.resolve().then(()=>r()).then(e=>({component:e&&e.default||e,exports:e}),e=>({error:e})):Promise.resolve(void 0)).then(r=>{let n=t.get(e);n&&"resolve"in n?r&&(t.set(e,r),n.resolve(r)):(r?t.set(e,r):t.delete(e),o.delete(e))})},loadRoute(r,n){return withFuture(r,o,()=>{let a;return resolvePromiseWithTimeout(getFilesForRoute(e,r).then(e=>{let{scripts:n,css:a}=e;return Promise.all([t.has(r)?[]:Promise.all(n.map(maybeExecuteScript)),Promise.all(a.map(fetchStyleSheet))])}).then(e=>this.whenEntrypoint(r).then(t=>({entrypoint:t,styles:e[1]}))),3800,markAssetError(Error("Route did not complete loading: "+r))).then(e=>{let{entrypoint:t,styles:r}=e,n=Object.assign({styles:r},t);return"error"in t?t:n}).catch(e=>{if(n)throw e;return{error:e}}).finally(()=>null==a?void 0:a())})},prefetch(t){let r;return(r=navigator.connection)&&(r.saveData||/2g/.test(r.effectiveType))?Promise.resolve():getFilesForRoute(e,t).then(e=>Promise.all(s?e.scripts.map(e=>{var t,r,n;return t=e.toString(),r="script",new Promise((e,a)=>{let o='\n      link[rel="prefetch"][href^="'+t+'"],\n      link[rel="preload"][href^="'+t+'"],\n      script[src^="'+t+'"]';if(document.querySelector(o))return e();n=document.createElement("link"),r&&(n.as=r),n.rel="prefetch",n.crossOrigin=void 0,n.onload=e,n.onerror=()=>a(markAssetError(Error("Failed to prefetch: "+t))),n.href=t,document.head.appendChild(n)})}):[])).then(()=>{(0,a.requestIdleCallback)(()=>this.loadRoute(t,!0).catch(()=>{}))}).catch(()=>{})}}}("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},404:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{Router:function(){return o.default},default:function(){return f},withRouter:function(){return l.default},useRouter:function(){return useRouter},createRouter:function(){return createRouter},makePublicRouterInstance:function(){return makePublicRouterInstance}});let n=r(50167),a=n._(r(16689)),o=n._(r(46142)),i=r(5469),s=n._(r(80676)),l=n._(r(67899)),u={router:null,readyCallbacks:[],ready(e){if(this.router)return e()}},c=["pathname","route","query","asPath","components","isFallback","basePath","locale","locales","defaultLocale","isReady","isPreview","isLocaleDomain","domainLocales"],d=["push","replace","reload","back","prefetch","beforePopState"];function getRouter(){if(!u.router)throw Error('No router instance found.\nYou should only use "next/router" on the client side of your app.\n');return u.router}Object.defineProperty(u,"events",{get:()=>o.default.events}),c.forEach(e=>{Object.defineProperty(u,e,{get(){let t=getRouter();return t[e]}})}),d.forEach(e=>{u[e]=function(){for(var t=arguments.length,r=Array(t),n=0;n<t;n++)r[n]=arguments[n];let a=getRouter();return a[e](...r)}}),["routeChangeStart","beforeHistoryChange","routeChangeComplete","routeChangeError","hashChangeStart","hashChangeComplete"].forEach(e=>{u.ready(()=>{o.default.events.on(e,function(){for(var t=arguments.length,r=Array(t),n=0;n<t;n++)r[n]=arguments[n];let a="on"+e.charAt(0).toUpperCase()+e.substring(1);if(u[a])try{u[a](...r)}catch(e){console.error("Error when running the Router event: "+a),console.error((0,s.default)(e)?e.message+"\n"+e.stack:e+"")}})})});let f=u;function useRouter(){let e=a.default.useContext(i.RouterContext);if(!e)throw Error("NextRouter was not mounted. https://nextjs.org/docs/messages/next-router-not-mounted");return e}function createRouter(){for(var e=arguments.length,t=Array(e),r=0;r<e;r++)t[r]=arguments[r];return u.router=new o.default(...t),u.readyCallbacks.forEach(e=>e()),u.readyCallbacks=[],u.router}function makePublicRouterInstance(e){let t={};for(let r of c){if("object"==typeof e[r]){t[r]=Object.assign(Array.isArray(e[r])?[]:{},e[r]);continue}t[r]=e[r]}return t.events=o.default.events,d.forEach(r=>{t[r]=function(){for(var t=arguments.length,n=Array(t),a=0;a<t;a++)n[a]=arguments[a];return e[r](...n)}}),t}("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},40746:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{handleClientScriptLoad:function(){return handleClientScriptLoad},initScriptLoader:function(){return initScriptLoader},default:function(){return p}});let n=r(50167),a=r(28760),o=n._(r(66405)),i=a._(r(16689)),s=r(41988),l=r(70604),u=r(75787),c=new Map,d=new Set,f=["onLoad","onReady","dangerouslySetInnerHTML","children","onError","strategy","stylesheets"],insertStylesheets=e=>{if(o.default.preinit){e.forEach(e=>{o.default.preinit(e,{as:"style"})});return}},loadScript=e=>{let{src:t,id:r,onLoad:n=()=>{},onReady:a=null,dangerouslySetInnerHTML:o,children:i="",strategy:s="afterInteractive",onError:u,stylesheets:p}=e,h=r||t;if(h&&d.has(h))return;if(c.has(t)){d.add(h),c.get(t).then(n,u);return}let afterLoad=()=>{a&&a(),d.add(h)},m=document.createElement("script"),g=new Promise((e,t)=>{m.addEventListener("load",function(t){e(),n&&n.call(this,t),afterLoad()}),m.addEventListener("error",function(e){t(e)})}).catch(function(e){u&&u(e)});for(let[r,n]of(o?(m.innerHTML=o.__html||"",afterLoad()):i?(m.textContent="string"==typeof i?i:Array.isArray(i)?i.join(""):"",afterLoad()):t&&(m.src=t,c.set(t,g)),Object.entries(e))){if(void 0===n||f.includes(r))continue;let e=l.DOMAttributeNames[r]||r.toLowerCase();m.setAttribute(e,n)}"worker"===s&&m.setAttribute("type","text/partytown"),m.setAttribute("data-nscript",s),p&&insertStylesheets(p),document.body.appendChild(m)};function handleClientScriptLoad(e){let{strategy:t="afterInteractive"}=e;"lazyOnload"===t?window.addEventListener("load",()=>{(0,u.requestIdleCallback)(()=>loadScript(e))}):loadScript(e)}function initScriptLoader(e){e.forEach(handleClientScriptLoad),function(){let e=[...document.querySelectorAll('[data-nscript="beforeInteractive"]'),...document.querySelectorAll('[data-nscript="beforePageRender"]')];e.forEach(e=>{let t=e.id||e.getAttribute("src");d.add(t)})}()}function Script(e){let{id:t,src:r="",onLoad:n=()=>{},onReady:a=null,strategy:l="afterInteractive",onError:c,stylesheets:f,...p}=e,{updateScripts:h,scripts:m,getIsSsr:g,appDir:y,nonce:v}=(0,i.useContext)(s.HeadManagerContext),_=(0,i.useRef)(!1);(0,i.useEffect)(()=>{let e=t||r;_.current||(a&&e&&d.has(e)&&a(),_.current=!0)},[a,t,r]);let b=(0,i.useRef)(!1);if((0,i.useEffect)(()=>{!b.current&&("afterInteractive"===l?loadScript(e):"lazyOnload"===l&&("complete"===document.readyState?(0,u.requestIdleCallback)(()=>loadScript(e)):window.addEventListener("load",()=>{(0,u.requestIdleCallback)(()=>loadScript(e))})),b.current=!0)},[e,l]),("beforeInteractive"===l||"worker"===l)&&(h?(m[l]=(m[l]||[]).concat([{id:t,src:r,onLoad:n,onReady:a,onError:c,...p}]),h(m)):g&&g()?d.add(t||r):g&&!g()&&loadScript(e)),y){if(f&&f.forEach(e=>{o.default.preinit(e,{as:"style"})}),"beforeInteractive"===l)return r?(o.default.preload(r,p.integrity?{as:"script",integrity:p.integrity}:{as:"script"}),i.default.createElement("script",{nonce:v,dangerouslySetInnerHTML:{__html:"(self.__next_s=self.__next_s||[]).push("+JSON.stringify([r])+")"}})):(p.dangerouslySetInnerHTML&&(p.children=p.dangerouslySetInnerHTML.__html,delete p.dangerouslySetInnerHTML),i.default.createElement("script",{nonce:v,dangerouslySetInnerHTML:{__html:"(self.__next_s=self.__next_s||[]).push("+JSON.stringify([0,{...p}])+")"}}));"afterInteractive"===l&&r&&o.default.preload(r,p.integrity?{as:"script",integrity:p.integrity}:{as:"script"})}return null}Object.defineProperty(Script,"__nextScript",{value:!0});let p=Script;("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},41195:(e,t)=>{"use strict";let r;function __unsafeCreateTrustedScriptURL(e){return(null==r?void 0:r.createScriptURL(e))||e}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"__unsafeCreateTrustedScriptURL",{enumerable:!0,get:function(){return __unsafeCreateTrustedScriptURL}}),("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},54714:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"useIntersection",{enumerable:!0,get:function(){return useIntersection}});let n=r(16689),a=r(75787),o="function"==typeof IntersectionObserver,i=new Map,s=[];function useIntersection(e){let{rootRef:t,rootMargin:r,disabled:l}=e,u=l||!o,[c,d]=(0,n.useState)(!1),f=(0,n.useRef)(null),p=(0,n.useCallback)(e=>{f.current=e},[]);(0,n.useEffect)(()=>{if(o){if(u||c)return;let e=f.current;if(e&&e.tagName){let n=function(e,t,r){let{id:n,observer:a,elements:o}=function(e){let t;let r={root:e.root||null,margin:e.rootMargin||""},n=s.find(e=>e.root===r.root&&e.margin===r.margin);if(n&&(t=i.get(n)))return t;let a=new Map,o=new IntersectionObserver(e=>{e.forEach(e=>{let t=a.get(e.target),r=e.isIntersecting||e.intersectionRatio>0;t&&r&&t(r)})},e);return t={id:r,observer:o,elements:a},s.push(r),i.set(r,t),t}(r);return o.set(e,t),a.observe(e),function(){if(o.delete(e),a.unobserve(e),0===o.size){a.disconnect(),i.delete(n);let e=s.findIndex(e=>e.root===n.root&&e.margin===n.margin);e>-1&&s.splice(e,1)}}}(e,e=>e&&d(e),{root:null==t?void 0:t.current,rootMargin:r});return n}}else if(!c){let e=(0,a.requestIdleCallback)(()=>d(!0));return()=>(0,a.cancelIdleCallback)(e)}},[u,r,t,c,f.current]);let h=(0,n.useCallback)(()=>{d(!1)},[]);return[p,c,h]}("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},67899:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"default",{enumerable:!0,get:function(){return withRouter}});let n=r(50167),a=n._(r(16689)),o=r(404);function withRouter(e){function WithRouterWrapper(t){return a.default.createElement(e,{router:(0,o.useRouter)(),...t})}return WithRouterWrapper.getInitialProps=e.getInitialProps,WithRouterWrapper.origGetInitialProps=e.origGetInitialProps,WithRouterWrapper}("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},23409:(e,t)=>{"use strict";function isInAmpMode(e){let{ampFirst:t=!1,hybrid:r=!1,hasQuery:n=!1}=void 0===e?{}:e;return t||r&&n}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"isInAmpMode",{enumerable:!0,get:function(){return isInAmpMode}})},82512:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"BloomFilter",{enumerable:!0,get:function(){return BloomFilter}});let BloomFilter=class BloomFilter{static from(e,t){void 0===t&&(t=.01);let r=new BloomFilter(e.length,t);for(let t of e)r.add(t);return r}export(){let e={numItems:this.numItems,errorRate:this.errorRate,numBits:this.numBits,numHashes:this.numHashes,bitArray:this.bitArray};if(this.errorRate<.01){let t=JSON.stringify(e),n=r(51662).sync(t);n>1024&&console.warn("Creating filter with error rate less than 1% (0.01) can increase the size dramatically proceed with caution. Received error rate "+this.errorRate+" resulted in size "+t.length+" bytes, "+n+" bytes (gzip)")}return e}import(e){this.numItems=e.numItems,this.errorRate=e.errorRate,this.numBits=e.numBits,this.numHashes=e.numHashes,this.bitArray=e.bitArray}add(e){let t=this.getHashValues(e);t.forEach(e=>{this.bitArray[e]=1})}contains(e){let t=this.getHashValues(e);return t.every(e=>this.bitArray[e])}getHashValues(e){let t=[];for(let r=1;r<=this.numHashes;r++){let n=function(e){let t=0;for(let r=0;r<e.length;r++){let n=e.charCodeAt(r);t=Math.imul(t^n,1540483477),t^=t>>>13,t=Math.imul(t,1540483477)}return t>>>0}(""+e+r)%this.numBits;t.push(n)}return t}constructor(e,t){this.numItems=e,this.errorRate=t,this.numBits=Math.ceil(-(e*Math.log(t))/(Math.log(2)*Math.log(2))),this.numHashes=Math.ceil(this.numBits/e*Math.log(2)),this.bitArray=Array(this.numBits).fill(0)}}},68563:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{noSSR:function(){return noSSR},default:function(){return dynamic}});let n=r(50167),a=n._(r(16689)),o=n._(r(74830));function convertModule(e){return{default:(null==e?void 0:e.default)||e}}function noSSR(e,t){delete t.webpack,delete t.modules;let r=t.loading;return()=>a.default.createElement(r,{error:null,isLoading:!0,pastDelay:!1,timedOut:!1})}function dynamic(e,t){let r=o.default,n={loading:e=>{let{error:t,isLoading:r,pastDelay:n}=e;return null}};e instanceof Promise?n.loader=()=>e:"function"==typeof e?n.loader=e:"object"==typeof e&&(n={...n,...e}),n={...n,...t};let a=n.loader;return(n.loadableGenerated&&(n={...n,...n.loadableGenerated},delete n.loadableGenerated),"boolean"!=typeof n.ssr||n.ssr)?r({...n,loader:()=>null!=a?a().then(convertModule):Promise.resolve(convertModule(()=>null))}):(delete n.webpack,delete n.modules,noSSR(r,n))}("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},7983:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"escapeStringRegexp",{enumerable:!0,get:function(){return escapeStringRegexp}});let r=/[|\\{}()[\]^$+*?.-]/,n=/[|\\{}()[\]^$+*?.-]/g;function escapeStringRegexp(e){return r.test(e)?e.replace(n,"\\$&"):e}},45803:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getImgProps",{enumerable:!0,get:function(){return getImgProps}}),r(74330);let n=r(50621),a=r(29175);function isStaticRequire(e){return void 0!==e.default}function getInt(e){return void 0===e?e:"number"==typeof e?Number.isFinite(e)?e:NaN:"string"==typeof e&&/^[0-9]+$/.test(e)?parseInt(e,10):NaN}function getImgProps(e,t){var r;let o,i,s,{src:l,sizes:u,unoptimized:c=!1,priority:d=!1,loading:f,className:p,quality:h,width:m,height:g,fill:y=!1,style:v,onLoad:_,onLoadingComplete:b,placeholder:P="empty",blurDataURL:x,fetchPriority:R,layout:S,objectFit:w,objectPosition:E,lazyBoundary:O,lazyRoot:j,...C}=e,{imgConf:A,showAltText:M,blurComplete:T,defaultLoader:I}=t,L=A||a.imageConfigDefault;if("allSizes"in L)o=L;else{let e=[...L.deviceSizes,...L.imageSizes].sort((e,t)=>e-t),t=L.deviceSizes.sort((e,t)=>e-t);o={...L,allSizes:e,deviceSizes:t}}let k=C.loader||I;delete C.loader,delete C.srcSet;let N="__next_img_default"in k;if(N){if("custom"===o.loader)throw Error('Image with src "'+l+'" is missing "loader" prop.\nRead more: https://nextjs.org/docs/messages/next-image-missing-loader')}else{let e=k;k=t=>{let{config:r,...n}=t;return e(n)}}if(S){"fill"===S&&(y=!0);let e={intrinsic:{maxWidth:"100%",height:"auto"},responsive:{width:"100%",height:"auto"}}[S];e&&(v={...v,...e});let t={responsive:"100vw",fill:"100vw"}[S];t&&!u&&(u=t)}let D="",U=getInt(m),H=getInt(g);if("object"==typeof(r=l)&&(isStaticRequire(r)||void 0!==r.src)){let e=isStaticRequire(l)?l.default:l;if(!e.src)throw Error("An object should only be passed to the image component src parameter if it comes from a static image import. It must include src. Received "+JSON.stringify(e));if(!e.height||!e.width)throw Error("An object should only be passed to the image component src parameter if it comes from a static image import. It must include height and width. Received "+JSON.stringify(e));if(i=e.blurWidth,s=e.blurHeight,x=x||e.blurDataURL,D=e.src,!y){if(U||H){if(U&&!H){let t=U/e.width;H=Math.round(e.height*t)}else if(!U&&H){let t=H/e.height;U=Math.round(e.width*t)}}else U=e.width,H=e.height}}let B=!d&&("lazy"===f||void 0===f);(!(l="string"==typeof l?l:D)||l.startsWith("data:")||l.startsWith("blob:"))&&(c=!0,B=!1),o.unoptimized&&(c=!0),N&&l.endsWith(".svg")&&!o.dangerouslyAllowSVG&&(c=!0),d&&(R="high");let F=getInt(h),z=Object.assign(y?{position:"absolute",height:"100%",width:"100%",left:0,top:0,right:0,bottom:0,objectFit:w,objectPosition:E}:{},M?{}:{color:"transparent"},v),q=T||"empty"===P?null:"blur"===P?'url("data:image/svg+xml;charset=utf-8,'+(0,n.getImageBlurSvg)({widthInt:U,heightInt:H,blurWidth:i,blurHeight:s,blurDataURL:x||"",objectFit:z.objectFit})+'")':'url("'+P+'")',W=q?{backgroundSize:z.objectFit||"cover",backgroundPosition:z.objectPosition||"50% 50%",backgroundRepeat:"no-repeat",backgroundImage:q}:{},$=function(e){let{config:t,src:r,unoptimized:n,width:a,quality:o,sizes:i,loader:s}=e;if(n)return{src:r,srcSet:void 0,sizes:void 0};let{widths:l,kind:u}=function(e,t,r){let{deviceSizes:n,allSizes:a}=e;if(r){let e=/(^|\s)(1?\d?\d)vw/g,t=[];for(let n;n=e.exec(r);n)t.push(parseInt(n[2]));if(t.length){let e=.01*Math.min(...t);return{widths:a.filter(t=>t>=n[0]*e),kind:"w"}}return{widths:a,kind:"w"}}if("number"!=typeof t)return{widths:n,kind:"w"};let o=[...new Set([t,2*t].map(e=>a.find(t=>t>=e)||a[a.length-1]))];return{widths:o,kind:"x"}}(t,a,i),c=l.length-1;return{sizes:i||"w"!==u?i:"100vw",srcSet:l.map((e,n)=>s({config:t,src:r,quality:o,width:e})+" "+("w"===u?e:n+1)+u).join(", "),src:s({config:t,src:r,quality:o,width:l[c]})}}({config:o,src:l,unoptimized:c,width:U,quality:F,sizes:u,loader:k}),V={...C,loading:B?"lazy":f,fetchPriority:R,width:U,height:H,decoding:"async",className:p,style:{...z,...W},sizes:$.sizes,srcSet:$.srcSet,src:$.src},G={unoptimized:c,priority:d,placeholder:P,fill:y};return{props:V,meta:G}}},80636:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{defaultHead:function(){return defaultHead},default:function(){return _default}});let n=r(50167),a=r(28760),o=a._(r(16689)),i=n._(r(11010)),s=r(98039),l=r(41988),u=r(23409);function defaultHead(e){void 0===e&&(e=!1);let t=[o.default.createElement("meta",{charSet:"utf-8"})];return e||t.push(o.default.createElement("meta",{name:"viewport",content:"width=device-width"})),t}function onlyReactElement(e,t){return"string"==typeof t||"number"==typeof t?e:t.type===o.default.Fragment?e.concat(o.default.Children.toArray(t.props.children).reduce((e,t)=>"string"==typeof t||"number"==typeof t?e:e.concat(t),[])):e.concat(t)}r(74330);let c=["name","httpEquiv","charSet","itemProp"];function reduceComponents(e,t){let{inAmpMode:r}=t;return e.reduce(onlyReactElement,[]).reverse().concat(defaultHead(r).reverse()).filter(function(){let e=new Set,t=new Set,r=new Set,n={};return a=>{let o=!0,i=!1;if(a.key&&"number"!=typeof a.key&&a.key.indexOf("$")>0){i=!0;let t=a.key.slice(a.key.indexOf("$")+1);e.has(t)?o=!1:e.add(t)}switch(a.type){case"title":case"base":t.has(a.type)?o=!1:t.add(a.type);break;case"meta":for(let e=0,t=c.length;e<t;e++){let t=c[e];if(a.props.hasOwnProperty(t)){if("charSet"===t)r.has(t)?o=!1:r.add(t);else{let e=a.props[t],r=n[t]||new Set;("name"!==t||!i)&&r.has(e)?o=!1:(r.add(e),n[t]=r)}}}}return o}}()).reverse().map((e,t)=>{let n=e.key||t;if(!r&&"link"===e.type&&e.props.href&&["https://fonts.googleapis.com/css","https://use.typekit.net/"].some(t=>e.props.href.startsWith(t))){let t={...e.props||{}};return t["data-href"]=t.href,t.href=void 0,t["data-optimized-fonts"]=!0,o.default.cloneElement(e,t)}return o.default.cloneElement(e,{key:n})})}let _default=function(e){let{children:t}=e,r=(0,o.useContext)(s.AmpStateContext),n=(0,o.useContext)(l.HeadManagerContext);return o.default.createElement(i.default,{reduceComponentsToState:reduceComponents,headManager:n,inAmpMode:(0,u.isInAmpMode)(r)},t)};("function"==typeof t.default||"object"==typeof t.default&&null!==t.default)&&void 0===t.default.__esModule&&(Object.defineProperty(t.default,"__esModule",{value:!0}),Object.assign(t.default,t),e.exports=t.default)},73238:(e,t)=>{"use strict";function normalizeLocalePath(e,t){let r;let n=e.split("/");return(t||[]).some(t=>!!n[1]&&n[1].toLowerCase()===t.toLowerCase()&&(r=t,n.splice(1,1),e=n.join("/")||"/",!0)),{pathname:e,detectedLocale:r}}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"normalizeLocalePath",{enumerable:!0,get:function(){return normalizeLocalePath}})},50621:(e,t)=>{"use strict";function getImageBlurSvg(e){let{widthInt:t,heightInt:r,blurWidth:n,blurHeight:a,blurDataURL:o,objectFit:i}=e,s=n?40*n:t,l=a?40*a:r,u=s&&l?"viewBox='0 0 "+s+" "+l+"'":"";return"%3Csvg xmlns='http://www.w3.org/2000/svg' "+u+"%3E%3Cfilter id='b' color-interpolation-filters='sRGB'%3E%3CfeGaussianBlur stdDeviation='20'/%3E%3CfeColorMatrix values='1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 100 -1' result='s'/%3E%3CfeFlood x='0' y='0' width='100%25' height='100%25'/%3E%3CfeComposite operator='out' in='s'/%3E%3CfeComposite in2='SourceGraphic'/%3E%3CfeGaussianBlur stdDeviation='20'/%3E%3C/filter%3E%3Cimage width='100%25' height='100%25' x='0' y='0' preserveAspectRatio='"+(u?"none":"contain"===i?"xMidYMid":"cover"===i?"xMidYMid slice":"none")+"' style='filter: url(%23b);' href='"+o+"'/%3E%3C/svg%3E"}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getImageBlurSvg",{enumerable:!0,get:function(){return getImageBlurSvg}})},29175:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{VALID_LOADERS:function(){return r},imageConfigDefault:function(){return n}});let r=["default","imgix","cloudinary","akamai","custom"],n={deviceSizes:[640,750,828,1080,1200,1920,2048,3840],imageSizes:[16,32,48,64,96,128,256,384],path:"/_next/image",loader:"default",loaderFile:"",domains:[],disableStaticImages:!1,minimumCacheTTL:60,formats:["image/webp"],dangerouslyAllowSVG:!1,contentSecurityPolicy:"script-src 'none'; frame-src 'none'; sandbox;",contentDispositionType:"inline",remotePatterns:[],unoptimized:!1}},73164:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{unstable_getImgProps:function(){return unstable_getImgProps},default:function(){return l}});let n=r(50167),a=r(45803),o=r(74330),i=r(71923),s=n._(r(41986)),unstable_getImgProps=e=>{(0,o.warnOnce)("Warning: unstable_getImgProps() is experimental and may change or be removed at any time. Use at your own risk.");let{props:t}=(0,a.getImgProps)(e,{defaultLoader:s.default,imgConf:{deviceSizes:[640,750,828,1080,1200,1920,2048,3840],imageSizes:[16,32,48,64,96,128,256,384],path:"/_next/image/",loader:"default",dangerouslyAllowSVG:!1,unoptimized:!0}});for(let[e,r]of Object.entries(t))void 0===r&&delete t[e];return{props:t}},l=i.Image},41986:(e,t)=>{"use strict";function defaultLoader(e){let{config:t,src:r,width:n,quality:a}=e;return t.path+"?url="+encodeURIComponent(r)+"&w="+n+"&q="+(a||75)}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"default",{enumerable:!0,get:function(){return r}}),defaultLoader.__next_img_default=!0;let r=defaultLoader},74383:(e,t)=>{"use strict";function mitt(){let e=Object.create(null);return{on(t,r){(e[t]||(e[t]=[])).push(r)},off(t,r){e[t]&&e[t].splice(e[t].indexOf(r)>>>0,1)},emit(t){for(var r=arguments.length,n=Array(r>1?r-1:0),a=1;a<r;a++)n[a-1]=arguments[a];(e[t]||[]).slice().map(e=>{e(...n)})}}}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"default",{enumerable:!0,get:function(){return mitt}})},46142:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{default:function(){return Router},matchesMiddleware:function(){return matchesMiddleware},createKey:function(){return createKey}});let n=r(50167),a=r(28760),o=r(84318),i=r(94107),s=r(40746),l=a._(r(80676)),u=r(18705),c=r(73238),d=n._(r(74383)),f=r(35504),p=r(68638),h=r(40840),m=n._(r(90133)),g=r(1211),y=r(51076),v=r(33512);r(68275);let _=r(55017),b=r(77836),P=r(36709),x=r(83698),R=r(68187),S=r(17361),w=r(28156),E=r(79423),O=r(2158),j=r(94364),C=r(59047),A=r(97106);r(31602);let M=r(2954),T=r(50584),I=r(45156);function buildCancellationError(){return Object.assign(Error("Route Cancelled"),{cancelled:!0})}async function matchesMiddleware(e){let t=await Promise.resolve(e.router.pageLoader.getMiddleware());if(!t)return!1;let{pathname:r}=(0,_.parsePath)(e.asPath),n=(0,S.hasBasePath)(r)?(0,x.removeBasePath)(r):r,a=(0,R.addBasePath)((0,b.addLocale)(n,e.locale));return t.some(e=>new RegExp(e.regexp).test(a))}function stripOrigin(e){let t=(0,f.getLocationOrigin)();return e.startsWith(t)?e.substring(t.length):e}function prepareUrlAs(e,t,r){let[n,a]=(0,w.resolveHref)(e,t,!0),o=(0,f.getLocationOrigin)(),i=n.startsWith(o),s=a&&a.startsWith(o);n=stripOrigin(n),a=a?stripOrigin(a):a;let l=i?n:(0,R.addBasePath)(n),u=r?stripOrigin((0,w.resolveHref)(e,r)):a||n;return{url:l,as:s?u:(0,R.addBasePath)(u)}}function resolveDynamicRoute(e,t){let r=(0,o.removeTrailingSlash)((0,u.denormalizePagePath)(e));return"/404"===r||"/_error"===r?e:(t.includes(r)||t.some(t=>{if((0,p.isDynamicRoute)(t)&&(0,y.getRouteRegex)(t).re.test(r))return e=t,!0}),(0,o.removeTrailingSlash)(e))}async function withMiddlewareEffects(e){let t=await matchesMiddleware(e);if(!t||!e.fetchData)return null;try{let t=await e.fetchData(),r=await function(e,t,r){let n={basePath:r.router.basePath,i18n:{locales:r.router.locales},trailingSlash:!0},a=t.headers.get("x-nextjs-rewrite"),s=a||t.headers.get("x-nextjs-matched-path"),l=t.headers.get("x-matched-path");if(!l||s||l.includes("__next_data_catchall")||l.includes("/_error")||l.includes("/404")||(s=l),s){if(s.startsWith("/")){let t=(0,h.parseRelativeUrl)(s),l=(0,O.getNextPathnameInfo)(t.pathname,{nextConfig:n,parseData:!0}),u=(0,o.removeTrailingSlash)(l.pathname);return Promise.all([r.router.pageLoader.getPageList(),(0,i.getClientBuildManifest)()]).then(n=>{let[o,{__rewrites:i}]=n,s=(0,b.addLocale)(l.pathname,l.locale);if((0,p.isDynamicRoute)(s)||!a&&o.includes((0,c.normalizeLocalePath)((0,x.removeBasePath)(s),r.router.locales).pathname)){let r=(0,O.getNextPathnameInfo)((0,h.parseRelativeUrl)(e).pathname,{nextConfig:void 0,parseData:!0});s=(0,R.addBasePath)(r.pathname),t.pathname=s}{let e=(0,m.default)(s,o,i,t.query,e=>resolveDynamicRoute(e,o),r.router.locales);e.matchedPage&&(t.pathname=e.parsedAs.pathname,s=t.pathname,Object.assign(t.query,e.parsedAs.query))}let d=o.includes(u)?u:resolveDynamicRoute((0,c.normalizeLocalePath)((0,x.removeBasePath)(t.pathname),r.router.locales).pathname,o);if((0,p.isDynamicRoute)(d)){let e=(0,g.getRouteMatcher)((0,y.getRouteRegex)(d))(s);Object.assign(t.query,e||{})}return{type:"rewrite",parsedAs:t,resolvedHref:d}})}let t=(0,_.parsePath)(e),l=(0,j.formatNextPathnameInfo)({...(0,O.getNextPathnameInfo)(t.pathname,{nextConfig:n,parseData:!0}),defaultLocale:r.router.defaultLocale,buildId:""});return Promise.resolve({type:"redirect-external",destination:""+l+t.query+t.hash})}let u=t.headers.get("x-nextjs-redirect");if(u){if(u.startsWith("/")){let e=(0,_.parsePath)(u),t=(0,j.formatNextPathnameInfo)({...(0,O.getNextPathnameInfo)(e.pathname,{nextConfig:n,parseData:!0}),defaultLocale:r.router.defaultLocale,buildId:""});return Promise.resolve({type:"redirect-internal",newAs:""+t+e.query+e.hash,newUrl:""+t+e.query+e.hash})}return Promise.resolve({type:"redirect-external",destination:u})}return Promise.resolve({type:"next"})}(t.dataHref,t.response,e);return{dataHref:t.dataHref,json:t.json,response:t.response,text:t.text,cacheKey:t.cacheKey,effect:r}}catch(e){return null}}let L=Symbol("SSG_DATA_NOT_FOUND");function tryToParseAsJSON(e){try{return JSON.parse(e)}catch(e){return null}}function fetchNextData(e){var t;let{dataHref:r,inflightCache:n,isPrefetch:a,hasMiddleware:o,isServerRender:s,parseJSON:l,persistCache:u,isBackground:c,unstable_skipClientCache:d}=e,{href:f}=new URL(r,window.location.href),getData=e=>(function fetchRetry(e,t,r){return fetch(e,{credentials:"same-origin",method:r.method||"GET",headers:Object.assign({},r.headers,{"x-nextjs-data":"1"})}).then(n=>!n.ok&&t>1&&n.status>=500?fetchRetry(e,t-1,r):n)})(r,s?3:1,{headers:Object.assign({},a?{purpose:"prefetch"}:{},a&&o?{"x-middleware-prefetch":"1"}:{}),method:null!=(t=null==e?void 0:e.method)?t:"GET"}).then(t=>t.ok&&(null==e?void 0:e.method)==="HEAD"?{dataHref:r,response:t,text:"",json:{},cacheKey:f}:t.text().then(e=>{if(!t.ok){if(o&&[301,302,307,308].includes(t.status))return{dataHref:r,response:t,text:e,json:{},cacheKey:f};if(404===t.status){var n;if(null==(n=tryToParseAsJSON(e))?void 0:n.notFound)return{dataHref:r,json:{notFound:L},response:t,text:e,cacheKey:f}}let a=Error("Failed to load static props");throw s||(0,i.markAssetError)(a),a}return{dataHref:r,json:l?tryToParseAsJSON(e):null,response:t,text:e,cacheKey:f}})).then(e=>(u&&"no-cache"!==e.response.headers.get("x-middleware-cache")||delete n[f],e)).catch(e=>{throw d||delete n[f],("Failed to fetch"===e.message||"NetworkError when attempting to fetch resource."===e.message||"Load failed"===e.message)&&(0,i.markAssetError)(e),e});return d&&u?getData({}).then(e=>(n[f]=Promise.resolve(e),e)):void 0!==n[f]?n[f]:n[f]=getData(c?{method:"HEAD"}:{})}function createKey(){return Math.random().toString(36).slice(2,10)}function handleHardNavigation(e){let{url:t,router:r}=e;if(t===(0,R.addBasePath)((0,b.addLocale)(r.asPath,r.locale)))throw Error("Invariant: attempted to hard navigate to the same URL "+t+" "+location.href);window.location.href=t}let getCancelledHandler=e=>{let{route:t,router:r}=e,n=!1,a=r.clc=()=>{n=!0};return()=>{if(n){let e=Error('Abort fetching component for route: "'+t+'"');throw e.cancelled=!0,e}a===r.clc&&(r.clc=null)}};let Router=class Router{reload(){window.location.reload()}back(){window.history.back()}forward(){window.history.forward()}push(e,t,r){return void 0===r&&(r={}),{url:e,as:t}=prepareUrlAs(this,e,t),this.change("pushState",e,t,r)}replace(e,t,r){return void 0===r&&(r={}),{url:e,as:t}=prepareUrlAs(this,e,t),this.change("replaceState",e,t,r)}async _bfl(e,t,r,n){{let l=!1,u=!1;for(let c of[e,t])if(c){let t=(0,o.removeTrailingSlash)(new URL(c,"http://n").pathname),d=(0,R.addBasePath)((0,b.addLocale)(t,r||this.locale));if(t!==(0,o.removeTrailingSlash)(new URL(this.asPath,"http://n").pathname)){var a,i,s;for(let e of(l=l||!!(null==(a=this._bfl_s)?void 0:a.contains(t))||!!(null==(i=this._bfl_s)?void 0:i.contains(d)),[t,d])){let t=e.split("/");for(let e=0;!u&&e<t.length+1;e++){let r=t.slice(0,e).join("/");if(r&&(null==(s=this._bfl_d)?void 0:s.contains(r))){u=!0;break}}}if(l||u){if(n)return!0;return handleHardNavigation({url:(0,R.addBasePath)((0,b.addLocale)(e,r||this.locale,this.defaultLocale)),router:this}),new Promise(()=>{})}}}}return!1}async change(e,t,r,n,a){var u,c,d,w,E,O,j,I,k;let N,D;if(!(0,A.isLocalURL)(t))return handleHardNavigation({url:t,router:this}),!1;let U=1===n._h;U||n.shallow||await this._bfl(r,void 0,n.locale);let H=U||n._shouldResolveHref||(0,_.parsePath)(t).pathname===(0,_.parsePath)(r).pathname,B={...this.state},F=!0!==this.isReady;this.isReady=!0;let z=this.isSsr;if(U||(this.isSsr=!1),U&&this.clc)return!1;let q=B.locale;f.ST&&performance.mark("routeChange");let{shallow:W=!1,scroll:$=!0}=n,V={shallow:W};this._inFlightRoute&&this.clc&&(z||Router.events.emit("routeChangeError",buildCancellationError(),this._inFlightRoute,V),this.clc(),this.clc=null),r=(0,R.addBasePath)((0,b.addLocale)((0,S.hasBasePath)(r)?(0,x.removeBasePath)(r):r,n.locale,this.defaultLocale));let G=(0,P.removeLocale)((0,S.hasBasePath)(r)?(0,x.removeBasePath)(r):r,B.locale);this._inFlightRoute=r;let K=q!==B.locale;if(!U&&this.onlyAHashChange(G)&&!K){B.asPath=G,Router.events.emit("hashChangeStart",r,V),this.changeState(e,t,r,{...n,scroll:!1}),$&&this.scrollToHash(G);try{await this.set(B,this.components[B.route],null)}catch(e){throw(0,l.default)(e)&&e.cancelled&&Router.events.emit("routeChangeError",e,G,V),e}return Router.events.emit("hashChangeComplete",r,V),!0}let Q=(0,h.parseRelativeUrl)(t),{pathname:X,query:J}=Q;if(null==(u=this.components[X])?void 0:u.__appRouter)return handleHardNavigation({url:r,router:this}),new Promise(()=>{});try{[N,{__rewrites:D}]=await Promise.all([this.pageLoader.getPageList(),(0,i.getClientBuildManifest)(),this.pageLoader.getMiddleware()])}catch(e){return handleHardNavigation({url:r,router:this}),!1}this.urlIsNew(G)||K||(e="replaceState");let Y=r;X=X?(0,o.removeTrailingSlash)((0,x.removeBasePath)(X)):X;let Z=(0,o.removeTrailingSlash)(X),ee=r.startsWith("/")&&(0,h.parseRelativeUrl)(r).pathname,et=!!(ee&&Z!==ee&&(!(0,p.isDynamicRoute)(Z)||!(0,g.getRouteMatcher)((0,y.getRouteRegex)(Z))(ee))),er=!n.shallow&&await matchesMiddleware({asPath:r,locale:B.locale,router:this});if(U&&er&&(H=!1),H&&"/_error"!==X){if(n._shouldResolveHref=!0,r.startsWith("/")){let e=(0,m.default)((0,R.addBasePath)((0,b.addLocale)(G,B.locale),!0),N,D,J,e=>resolveDynamicRoute(e,N),this.locales);if(e.externalDest)return handleHardNavigation({url:r,router:this}),!0;er||(Y=e.asPath),e.matchedPage&&e.resolvedHref&&(X=e.resolvedHref,Q.pathname=(0,R.addBasePath)(X),er||(t=(0,v.formatWithValidation)(Q)))}else Q.pathname=resolveDynamicRoute(X,N),Q.pathname===X||(X=Q.pathname,Q.pathname=(0,R.addBasePath)(X),er||(t=(0,v.formatWithValidation)(Q)))}if(!(0,A.isLocalURL)(r))return handleHardNavigation({url:r,router:this}),!1;Y=(0,P.removeLocale)((0,x.removeBasePath)(Y),B.locale),Z=(0,o.removeTrailingSlash)(X);let en=!1;if((0,p.isDynamicRoute)(Z)){let e=(0,h.parseRelativeUrl)(Y),n=e.pathname,a=(0,y.getRouteRegex)(Z);en=(0,g.getRouteMatcher)(a)(n);let o=Z===n,i=o?(0,T.interpolateAs)(Z,n,J):{};if(en&&(!o||i.result))o?r=(0,v.formatWithValidation)(Object.assign({},e,{pathname:i.result,query:(0,M.omit)(J,i.params)})):Object.assign(J,en);else{let e=Object.keys(a.groups).filter(e=>!J[e]&&!a.groups[e].optional);if(e.length>0&&!er)throw Error((o?"The provided `href` ("+t+") value is missing query values ("+e.join(", ")+") to be interpolated properly. ":"The provided `as` value ("+n+") is incompatible with the `href` value ("+Z+"). ")+"Read more: https://nextjs.org/docs/messages/"+(o?"href-interpolation-failed":"incompatible-href-as"))}}U||Router.events.emit("routeChangeStart",r,V);let ea="/404"===this.pathname||"/_error"===this.pathname;try{let o=await this.getRouteInfo({route:Z,pathname:X,query:J,as:r,resolvedAs:Y,routeProps:V,locale:B.locale,isPreview:B.isPreview,hasMiddleware:er,unstable_skipClientCache:n.unstable_skipClientCache,isQueryUpdating:U&&!this.isFallback,isMiddlewareRewrite:et});if(U||n.shallow||await this._bfl(r,"resolvedAs"in o?o.resolvedAs:void 0,B.locale),"route"in o&&er){Z=X=o.route||Z,V.shallow||(J=Object.assign({},o.query||{},J));let e=(0,S.hasBasePath)(Q.pathname)?(0,x.removeBasePath)(Q.pathname):Q.pathname;if(en&&X!==e&&Object.keys(en).forEach(e=>{en&&J[e]===en[e]&&delete J[e]}),(0,p.isDynamicRoute)(X)){let e=!V.shallow&&o.resolvedAs?o.resolvedAs:(0,R.addBasePath)((0,b.addLocale)(new URL(r,location.href).pathname,B.locale),!0),t=e;(0,S.hasBasePath)(t)&&(t=(0,x.removeBasePath)(t));let n=(0,y.getRouteRegex)(X),a=(0,g.getRouteMatcher)(n)(new URL(t,location.href).pathname);a&&Object.assign(J,a)}}if("type"in o){if("redirect-internal"===o.type)return this.change(e,o.newUrl,o.newAs,n);return handleHardNavigation({url:o.destination,router:this}),new Promise(()=>{})}let i=o.Component;if(i&&i.unstable_scriptLoader){let e=[].concat(i.unstable_scriptLoader());e.forEach(e=>{(0,s.handleClientScriptLoad)(e.props)})}if((o.__N_SSG||o.__N_SSP)&&o.props){if(o.props.pageProps&&o.props.pageProps.__N_REDIRECT){n.locale=!1;let t=o.props.pageProps.__N_REDIRECT;if(t.startsWith("/")&&!1!==o.props.pageProps.__N_REDIRECT_BASE_PATH){let r=(0,h.parseRelativeUrl)(t);r.pathname=resolveDynamicRoute(r.pathname,N);let{url:a,as:o}=prepareUrlAs(this,t,t);return this.change(e,a,o,n)}return handleHardNavigation({url:t,router:this}),new Promise(()=>{})}if(B.isPreview=!!o.props.__N_PREVIEW,o.props.notFound===L){let e;try{await this.fetchComponent("/404"),e="/404"}catch(t){e="/_error"}if(o=await this.getRouteInfo({route:e,pathname:e,query:J,as:r,resolvedAs:Y,routeProps:{shallow:!1},locale:B.locale,isPreview:B.isPreview,isNotFound:!0}),"type"in o)throw Error("Unexpected middleware effect on /404")}}U&&"/_error"===this.pathname&&(null==(d=self.__NEXT_DATA__.props)?void 0:null==(c=d.pageProps)?void 0:c.statusCode)===500&&(null==(w=o.props)?void 0:w.pageProps)&&(o.props.pageProps.statusCode=500);let u=n.shallow&&B.route===(null!=(E=o.route)?E:Z),f=null!=(O=n.scroll)?O:!U&&!u,m=null!=a?a:f?{x:0,y:0}:null,v={...B,route:Z,pathname:X,query:J,asPath:G,isFallback:!1};if(U&&ea){if(o=await this.getRouteInfo({route:this.pathname,pathname:this.pathname,query:J,as:r,resolvedAs:Y,routeProps:{shallow:!1},locale:B.locale,isPreview:B.isPreview,isQueryUpdating:U&&!this.isFallback}),"type"in o)throw Error("Unexpected middleware effect on "+this.pathname);"/_error"===this.pathname&&(null==(I=self.__NEXT_DATA__.props)?void 0:null==(j=I.pageProps)?void 0:j.statusCode)===500&&(null==(k=o.props)?void 0:k.pageProps)&&(o.props.pageProps.statusCode=500);try{await this.set(v,o,m)}catch(e){throw(0,l.default)(e)&&e.cancelled&&Router.events.emit("routeChangeError",e,G,V),e}return!0}Router.events.emit("beforeHistoryChange",r,V),this.changeState(e,t,r,n);let _=U&&!m&&!F&&!K&&(0,C.compareRouterStates)(v,this.state);if(!_){try{await this.set(v,o,m)}catch(e){if(e.cancelled)o.error=o.error||e;else throw e}if(o.error)throw U||Router.events.emit("routeChangeError",o.error,G,V),o.error;U||Router.events.emit("routeChangeComplete",r,V),f&&/#.+$/.test(r)&&this.scrollToHash(r)}return!0}catch(e){if((0,l.default)(e)&&e.cancelled)return!1;throw e}}changeState(e,t,r,n){void 0===n&&(n={}),("pushState"!==e||(0,f.getURL)()!==r)&&(this._shallow=n.shallow,window.history[e]({url:t,as:r,options:n,__N:!0,key:this._key="pushState"!==e?this._key:createKey()},"",r))}async handleRouteInfoError(e,t,r,n,a,o){if(console.error(e),e.cancelled)throw e;if((0,i.isAssetError)(e)||o)throw Router.events.emit("routeChangeError",e,n,a),handleHardNavigation({url:n,router:this}),buildCancellationError();try{let n;let{page:a,styleSheets:o}=await this.fetchComponent("/_error"),i={props:n,Component:a,styleSheets:o,err:e,error:e};if(!i.props)try{i.props=await this.getInitialProps(a,{err:e,pathname:t,query:r})}catch(e){console.error("Error in error page `getInitialProps`: ",e),i.props={}}return i}catch(e){return this.handleRouteInfoError((0,l.default)(e)?e:Error(e+""),t,r,n,a,!0)}}async getRouteInfo(e){let{route:t,pathname:r,query:n,as:a,resolvedAs:i,routeProps:s,locale:u,hasMiddleware:d,isPreview:f,unstable_skipClientCache:p,isQueryUpdating:h,isMiddlewareRewrite:m,isNotFound:g}=e,y=t;try{var _,b,P,R;let e=getCancelledHandler({route:y,router:this}),t=this.components[y];if(s.shallow&&t&&this.route===y)return t;d&&(t=void 0);let l=!t||"initial"in t?void 0:t,S={dataHref:this.pageLoader.getDataHref({href:(0,v.formatWithValidation)({pathname:r,query:n}),skipInterpolation:!0,asPath:g?"/404":i,locale:u}),hasMiddleware:!0,isServerRender:this.isSsr,parseJSON:!0,inflightCache:h?this.sbc:this.sdc,persistCache:!f,isPrefetch:!1,unstable_skipClientCache:p,isBackground:h},w=h&&!m?null:await withMiddlewareEffects({fetchData:()=>fetchNextData(S),asPath:g?"/404":i,locale:u,router:this}).catch(e=>{if(h)return null;throw e});if(w&&("/_error"===r||"/404"===r)&&(w.effect=void 0),h&&(w?w.json=self.__NEXT_DATA__.props:w={json:self.__NEXT_DATA__.props}),e(),(null==w?void 0:null==(_=w.effect)?void 0:_.type)==="redirect-internal"||(null==w?void 0:null==(b=w.effect)?void 0:b.type)==="redirect-external")return w.effect;if((null==w?void 0:null==(P=w.effect)?void 0:P.type)==="rewrite"){let e=(0,o.removeTrailingSlash)(w.effect.resolvedHref),a=await this.pageLoader.getPageList();if((!h||a.includes(e))&&(y=e,r=w.effect.resolvedHref,n={...n,...w.effect.parsedAs.query},i=(0,x.removeBasePath)((0,c.normalizeLocalePath)(w.effect.parsedAs.pathname,this.locales).pathname),t=this.components[y],s.shallow&&t&&this.route===y&&!d))return{...t,route:y}}if((0,E.isAPIRoute)(y))return handleHardNavigation({url:a,router:this}),new Promise(()=>{});let O=l||await this.fetchComponent(y).then(e=>({Component:e.page,styleSheets:e.styleSheets,__N_SSG:e.mod.__N_SSG,__N_SSP:e.mod.__N_SSP})),j=null==w?void 0:null==(R=w.response)?void 0:R.headers.get("x-middleware-skip"),C=O.__N_SSG||O.__N_SSP;j&&(null==w?void 0:w.dataHref)&&delete this.sdc[w.dataHref];let{props:A,cacheKey:M}=await this._getData(async()=>{if(C){if((null==w?void 0:w.json)&&!j)return{cacheKey:w.cacheKey,props:w.json};let e=(null==w?void 0:w.dataHref)?w.dataHref:this.pageLoader.getDataHref({href:(0,v.formatWithValidation)({pathname:r,query:n}),asPath:i,locale:u}),t=await fetchNextData({dataHref:e,isServerRender:this.isSsr,parseJSON:!0,inflightCache:j?{}:this.sdc,persistCache:!f,isPrefetch:!1,unstable_skipClientCache:p});return{cacheKey:t.cacheKey,props:t.json||{}}}return{headers:{},props:await this.getInitialProps(O.Component,{pathname:r,query:n,asPath:a,locale:u,locales:this.locales,defaultLocale:this.defaultLocale})}});return O.__N_SSP&&S.dataHref&&M&&delete this.sdc[M],this.isPreview||!O.__N_SSG||h||fetchNextData(Object.assign({},S,{isBackground:!0,persistCache:!1,inflightCache:this.sbc})).catch(()=>{}),A.pageProps=Object.assign({},A.pageProps),O.props=A,O.route=y,O.query=n,O.resolvedAs=i,this.components[y]=O,O}catch(e){return this.handleRouteInfoError((0,l.getProperError)(e),r,n,a,s)}}set(e,t,r){return this.state=e,this.sub(t,this.components["/_app"].Component,r)}beforePopState(e){this._bps=e}onlyAHashChange(e){if(!this.asPath)return!1;let[t,r]=this.asPath.split("#"),[n,a]=e.split("#");return!!a&&t===n&&r===a||t===n&&r!==a}scrollToHash(e){let[,t=""]=e.split("#");(0,I.handleSmoothScroll)(()=>{if(""===t||"top"===t){window.scrollTo(0,0);return}let e=decodeURIComponent(t),r=document.getElementById(e);if(r){r.scrollIntoView();return}let n=document.getElementsByName(e)[0];n&&n.scrollIntoView()},{onlyHashChange:this.onlyAHashChange(e)})}urlIsNew(e){return this.asPath!==e}async prefetch(e,t,r){void 0===t&&(t=e),void 0===r&&(r={});let n=(0,h.parseRelativeUrl)(e),a=n.pathname,{pathname:s,query:l}=n,u=s,c=await this.pageLoader.getPageList(),d=t,f=void 0!==r.locale?r.locale||void 0:this.locale,S=await matchesMiddleware({asPath:t,locale:f,router:this});if(t.startsWith("/")){let r;({__rewrites:r}=await (0,i.getClientBuildManifest)());let a=(0,m.default)((0,R.addBasePath)((0,b.addLocale)(t,this.locale),!0),c,r,n.query,e=>resolveDynamicRoute(e,c),this.locales);if(a.externalDest)return;S||(d=(0,P.removeLocale)((0,x.removeBasePath)(a.asPath),this.locale)),a.matchedPage&&a.resolvedHref&&(s=a.resolvedHref,n.pathname=s,S||(e=(0,v.formatWithValidation)(n)))}n.pathname=resolveDynamicRoute(n.pathname,c),(0,p.isDynamicRoute)(n.pathname)&&(s=n.pathname,n.pathname=s,Object.assign(l,(0,g.getRouteMatcher)((0,y.getRouteRegex)(n.pathname))((0,_.parsePath)(t).pathname)||{}),S||(e=(0,v.formatWithValidation)(n)));let w=await withMiddlewareEffects({fetchData:()=>fetchNextData({dataHref:this.pageLoader.getDataHref({href:(0,v.formatWithValidation)({pathname:u,query:l}),skipInterpolation:!0,asPath:d,locale:f}),hasMiddleware:!0,isServerRender:this.isSsr,parseJSON:!0,inflightCache:this.sdc,persistCache:!this.isPreview,isPrefetch:!0}),asPath:t,locale:f,router:this});if((null==w?void 0:w.effect.type)==="rewrite"&&(n.pathname=w.effect.resolvedHref,s=w.effect.resolvedHref,l={...l,...w.effect.parsedAs.query},d=w.effect.parsedAs.pathname,e=(0,v.formatWithValidation)(n)),(null==w?void 0:w.effect.type)==="redirect-external")return;let E=(0,o.removeTrailingSlash)(s);await this._bfl(t,d,r.locale,!0)&&(this.components[a]={__appRouter:!0}),await Promise.all([this.pageLoader._isSsg(E).then(t=>!!t&&fetchNextData({dataHref:(null==w?void 0:w.json)?null==w?void 0:w.dataHref:this.pageLoader.getDataHref({href:e,asPath:d,locale:f}),isServerRender:!1,parseJSON:!0,inflightCache:this.sdc,persistCache:!this.isPreview,isPrefetch:!0,unstable_skipClientCache:r.unstable_skipClientCache||r.priority&&!0}).then(()=>!1).catch(()=>!1)),this.pageLoader[r.priority?"loadPage":"prefetch"](E)])}async fetchComponent(e){let t=getCancelledHandler({route:e,router:this});try{let r=await this.pageLoader.loadPage(e);return t(),r}catch(e){throw t(),e}}_getData(e){let t=!1,cancel=()=>{t=!0};return this.clc=cancel,e().then(e=>{if(cancel===this.clc&&(this.clc=null),t){let e=Error("Loading initial props cancelled");throw e.cancelled=!0,e}return e})}_getFlightData(e){return fetchNextData({dataHref:e,isServerRender:!0,parseJSON:!1,inflightCache:this.sdc,persistCache:!1,isPrefetch:!1}).then(e=>{let{text:t}=e;return{data:t}})}getInitialProps(e,t){let{Component:r}=this.components["/_app"],n=this._wrapApp(r);return t.AppTree=n,(0,f.loadGetInitialProps)(r,{AppTree:n,Component:e,router:this,ctx:t})}get route(){return this.state.route}get pathname(){return this.state.pathname}get query(){return this.state.query}get asPath(){return this.state.asPath}get locale(){return this.state.locale}get isFallback(){return this.state.isFallback}get isPreview(){return this.state.isPreview}constructor(e,t,n,{initialProps:a,pageLoader:i,App:s,wrapApp:l,Component:u,err:c,subscription:d,isFallback:m,locale:g,locales:y,defaultLocale:_,domainLocales:b,isPreview:P}){this.sdc={},this.sbc={},this.isFirstPopStateEvent=!0,this._key=createKey(),this.onPopState=e=>{let t;let{isFirstPopStateEvent:r}=this;this.isFirstPopStateEvent=!1;let n=e.state;if(!n){let{pathname:e,query:t}=this;this.changeState("replaceState",(0,v.formatWithValidation)({pathname:(0,R.addBasePath)(e),query:t}),(0,f.getURL)());return}if(n.__NA){window.location.reload();return}if(!n.__N||r&&this.locale===n.options.locale&&n.as===this.asPath)return;let{url:a,as:o,options:i,key:s}=n;this._key=s;let{pathname:l}=(0,h.parseRelativeUrl)(a);(!this.isSsr||o!==(0,R.addBasePath)(this.asPath)||l!==(0,R.addBasePath)(this.pathname))&&(!this._bps||this._bps(n))&&this.change("replaceState",a,o,Object.assign({},i,{shallow:i.shallow&&this._shallow,locale:i.locale||this.defaultLocale,_h:0}),t)};let x=(0,o.removeTrailingSlash)(e);this.components={},"/_error"!==e&&(this.components[x]={Component:u,initial:!0,props:a,err:c,__N_SSG:a&&a.__N_SSG,__N_SSP:a&&a.__N_SSP}),this.components["/_app"]={Component:s,styleSheets:[]};{let{BloomFilter:e}=r(82512),t={numItems:0,errorRate:.01,numBits:0,numHashes:null,bitArray:[]},n={numItems:0,errorRate:.01,numBits:0,numHashes:null,bitArray:[]};(null==t?void 0:t.numHashes)&&(this._bfl_s=new e(t.numItems,t.errorRate),this._bfl_s.import(t)),(null==n?void 0:n.numHashes)&&(this._bfl_d=new e(n.numItems,n.errorRate),this._bfl_d.import(n))}this.events=Router.events,this.pageLoader=i;let S=(0,p.isDynamicRoute)(e)&&self.__NEXT_DATA__.autoExport;this.basePath="",this.sub=d,this.clc=null,this._wrapApp=l,this.isSsr=!0,this.isLocaleDomain=!1,this.isReady=!!(self.__NEXT_DATA__.gssp||self.__NEXT_DATA__.gip||self.__NEXT_DATA__.isExperimentalCompile||self.__NEXT_DATA__.appGip&&!self.__NEXT_DATA__.gsp||(S||self.location.search,0)),this.state={route:x,pathname:e,query:t,asPath:S?e:n,isPreview:!!P,locale:void 0,isFallback:m},this._initialMatchesMiddlewarePromise=Promise.resolve(!1)}};Router.events=(0,d.default)()},76515:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"addLocale",{enumerable:!0,get:function(){return addLocale}});let n=r(36033),a=r(30619);function addLocale(e,t,r,o){if(!t||t===r)return e;let i=e.toLowerCase();return!o&&((0,a.pathHasPrefix)(i,"/api")||(0,a.pathHasPrefix)(i,"/"+t.toLowerCase()))?e:(0,n.addPathPrefix)(e,"/"+t)}},36033:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"addPathPrefix",{enumerable:!0,get:function(){return addPathPrefix}});let n=r(55017);function addPathPrefix(e,t){if(!e.startsWith("/")||!t)return e;let{pathname:r,query:a,hash:o}=(0,n.parsePath)(e);return""+t+r+a+o}},87341:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"addPathSuffix",{enumerable:!0,get:function(){return addPathSuffix}});let n=r(55017);function addPathSuffix(e,t){if(!e.startsWith("/")||!t)return e;let{pathname:r,query:a,hash:o}=(0,n.parsePath)(e);return""+r+t+a+o}},11418:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{normalizeAppPath:function(){return normalizeAppPath},normalizeRscPath:function(){return normalizeRscPath}});let n=r(8044),a=r(45906);function normalizeAppPath(e){return(0,n.ensureLeadingSlash)(e.split("/").reduce((e,t,r,n)=>!t||(0,a.isGroupSegment)(t)||"@"===t[0]||("page"===t||"route"===t)&&r===n.length-1?e:e+"/"+t,""))}function normalizeRscPath(e,t){return t?e.replace(/\.rsc($|\?)/,"$1"):e}},59047:(e,t)=>{"use strict";function compareRouterStates(e,t){let r=Object.keys(e);if(r.length!==Object.keys(t).length)return!1;for(let n=r.length;n--;){let a=r[n];if("query"===a){let r=Object.keys(e.query);if(r.length!==Object.keys(t.query).length)return!1;for(let n=r.length;n--;){let a=r[n];if(!t.query.hasOwnProperty(a)||e.query[a]!==t.query[a])return!1}}else if(!t.hasOwnProperty(a)||e[a]!==t[a])return!1}return!0}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"compareRouterStates",{enumerable:!0,get:function(){return compareRouterStates}})},94364:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"formatNextPathnameInfo",{enumerable:!0,get:function(){return formatNextPathnameInfo}});let n=r(84318),a=r(36033),o=r(87341),i=r(76515);function formatNextPathnameInfo(e){let t=(0,i.addLocale)(e.pathname,e.locale,e.buildId?void 0:e.defaultLocale,e.ignorePrefix);return(e.buildId||!e.trailingSlash)&&(t=(0,n.removeTrailingSlash)(t)),e.buildId&&(t=(0,o.addPathSuffix)((0,a.addPathPrefix)(t,"/_next/data/"+e.buildId),"/"===e.pathname?"index.json":".json")),t=(0,a.addPathPrefix)(t,e.basePath),!e.buildId&&e.trailingSlash?t.endsWith("/")?t:(0,o.addPathSuffix)(t,"/"):(0,n.removeTrailingSlash)(t)}},33512:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{formatUrl:function(){return formatUrl},urlObjectKeys:function(){return i},formatWithValidation:function(){return formatWithValidation}});let n=r(28760),a=n._(r(57655)),o=/https?|ftp|gopher|file/;function formatUrl(e){let{auth:t,hostname:r}=e,n=e.protocol||"",i=e.pathname||"",s=e.hash||"",l=e.query||"",u=!1;t=t?encodeURIComponent(t).replace(/%3A/i,":")+"@":"",e.host?u=t+e.host:r&&(u=t+(~r.indexOf(":")?"["+r+"]":r),e.port&&(u+=":"+e.port)),l&&"object"==typeof l&&(l=String(a.urlQueryToSearchParams(l)));let c=e.search||l&&"?"+l||"";return n&&!n.endsWith(":")&&(n+=":"),e.slashes||(!n||o.test(n))&&!1!==u?(u="//"+(u||""),i&&"/"!==i[0]&&(i="/"+i)):u||(u=""),s&&"#"!==s[0]&&(s="#"+s),c&&"?"!==c[0]&&(c="?"+c),""+n+u+(i=i.replace(/[?#]/g,encodeURIComponent))+(c=c.replace("#","%23"))+s}let i=["auth","hash","host","hostname","href","path","pathname","port","protocol","query","search","slashes"];function formatWithValidation(e){return formatUrl(e)}},83654:(e,t)=>{"use strict";function getAssetPathFromRoute(e,t){void 0===t&&(t="");let r="/"===e?"/index":/^\/index(\/|$)/.test(e)?"/index"+e:""+e;return r+t}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"default",{enumerable:!0,get:function(){return getAssetPathFromRoute}})},2158:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getNextPathnameInfo",{enumerable:!0,get:function(){return getNextPathnameInfo}});let n=r(73238),a=r(63049),o=r(30619);function getNextPathnameInfo(e,t){var r,i;let{basePath:s,i18n:l,trailingSlash:u}=null!=(r=t.nextConfig)?r:{},c={pathname:e,trailingSlash:"/"!==e?e.endsWith("/"):u};s&&(0,o.pathHasPrefix)(c.pathname,s)&&(c.pathname=(0,a.removePathPrefix)(c.pathname,s),c.basePath=s);let d=c.pathname;if(c.pathname.startsWith("/_next/data/")&&c.pathname.endsWith(".json")){let e=c.pathname.replace(/^\/_next\/data\//,"").replace(/\.json$/,"").split("/"),r=e[0];c.buildId=r,d="index"!==e[1]?"/"+e.slice(1).join("/"):"/",!0===t.parseData&&(c.pathname=d)}if(l){let e=t.i18nProvider?t.i18nProvider.analyze(c.pathname):(0,n.normalizeLocalePath)(c.pathname,l.locales);c.locale=e.detectedLocale,c.pathname=null!=(i=e.pathname)?i:c.pathname,!e.detectedLocale&&c.buildId&&(e=t.i18nProvider?t.i18nProvider.analyze(d):(0,n.normalizeLocalePath)(d,l.locales)).detectedLocale&&(c.locale=e.detectedLocale)}return c}},45156:(e,t)=>{"use strict";function handleSmoothScroll(e,t){if(void 0===t&&(t={}),t.onlyHashChange){e();return}let r=document.documentElement,n=r.style.scrollBehavior;r.style.scrollBehavior="auto",t.dontForceLayout||r.getClientRects(),e(),r.style.scrollBehavior=n}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"handleSmoothScroll",{enumerable:!0,get:function(){return handleSmoothScroll}})},50584:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"interpolateAs",{enumerable:!0,get:function(){return interpolateAs}});let n=r(1211),a=r(51076);function interpolateAs(e,t,r){let o="",i=(0,a.getRouteRegex)(e),s=i.groups,l=(t!==e?(0,n.getRouteMatcher)(i)(t):"")||r;o=e;let u=Object.keys(s);return u.every(e=>{let t=l[e]||"",{repeat:r,optional:n}=s[e],a="["+(r?"...":"")+e+"]";return n&&(a=(t?"":"/")+"["+a+"]"),r&&!Array.isArray(t)&&(t=[t]),(n||e in l)&&(o=o.replace(a,r?t.map(e=>encodeURIComponent(e)).join("/"):encodeURIComponent(t))||"/")})||(o=""),{params:u,result:o}}},31602:(e,t)=>{"use strict";function isBot(e){return/Googlebot|Mediapartners-Google|AdsBot-Google|googleweblight|Storebot-Google|Google-PageRenderer|Bingbot|BingPreview|Slurp|DuckDuckBot|baiduspider|yandex|sogou|LinkedInBot|bitlybot|tumblr|vkShare|quora link preview|facebookexternalhit|facebookcatalog|Twitterbot|applebot|redditbot|Slackbot|Discordbot|WhatsApp|SkypeUriPreview|ia_archiver/i.test(e)}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"isBot",{enumerable:!0,get:function(){return isBot}})},97106:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"isLocalURL",{enumerable:!0,get:function(){return isLocalURL}});let n=r(35504),a=r(17361);function isLocalURL(e){if(!(0,n.isAbsoluteUrl)(e))return!0;try{let t=(0,n.getLocationOrigin)(),r=new URL(e,t);return r.origin===t&&(0,a.hasBasePath)(r.pathname)}catch(e){return!1}}},2954:(e,t)=>{"use strict";function omit(e,t){let r={};return Object.keys(e).forEach(n=>{t.includes(n)||(r[n]=e[n])}),r}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"omit",{enumerable:!0,get:function(){return omit}})},55017:(e,t)=>{"use strict";function parsePath(e){let t=e.indexOf("#"),r=e.indexOf("?"),n=r>-1&&(t<0||r<t);return n||t>-1?{pathname:e.substring(0,n?r:t),query:n?e.substring(r,t>-1?t:void 0):"",hash:t>-1?e.slice(t):""}:{pathname:e,query:"",hash:""}}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"parsePath",{enumerable:!0,get:function(){return parsePath}})},40840:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"parseRelativeUrl",{enumerable:!0,get:function(){return parseRelativeUrl}}),r(35504);let n=r(57655);function parseRelativeUrl(e,t){let r=new URL("http://n"),a=t?new URL(t,r):e.startsWith(".")?new URL("http://n"):r,{pathname:o,searchParams:i,search:s,hash:l,href:u,origin:c}=new URL(e,a);if(c!==r.origin)throw Error("invariant: invalid relative URL, router received "+e);return{pathname:o,query:(0,n.searchParamsToUrlQuery)(i),search:s,hash:l,href:u.slice(r.origin.length)}}},48902:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"parseUrl",{enumerable:!0,get:function(){return parseUrl}});let n=r(57655),a=r(40840);function parseUrl(e){if(e.startsWith("/"))return(0,a.parseRelativeUrl)(e);let t=new URL(e);return{hash:t.hash,hostname:t.hostname,href:t.href,pathname:t.pathname,port:t.port,protocol:t.protocol,query:(0,n.searchParamsToUrlQuery)(t.searchParams),search:t.search}}},30619:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"pathHasPrefix",{enumerable:!0,get:function(){return pathHasPrefix}});let n=r(55017);function pathHasPrefix(e,t){if("string"!=typeof e)return!1;let{pathname:r}=(0,n.parsePath)(e);return r===t||r.startsWith(t+"/")}},8673:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getPathMatch",{enumerable:!0,get:function(){return getPathMatch}});let n=r(74329);function getPathMatch(e,t){let r=[],a=(0,n.pathToRegexp)(e,r,{delimiter:"/",sensitive:"boolean"==typeof(null==t?void 0:t.sensitive)&&t.sensitive,strict:null==t?void 0:t.strict}),o=(0,n.regexpToFunction)((null==t?void 0:t.regexModifier)?new RegExp(t.regexModifier(a.source),a.flags):a,r);return(e,n)=>{if("string"!=typeof e)return!1;let a=o(e);if(!a)return!1;if(null==t?void 0:t.removeUnnamedParams)for(let e of r)"number"==typeof e.name&&delete a.params[e.name];return{...n,...a.params}}}},55816:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{matchHas:function(){return matchHas},compileNonPath:function(){return compileNonPath},prepareDestination:function(){return prepareDestination}});let n=r(74329),a=r(7983),o=r(48902),i=r(92407),s=r(85107),l=r(11730);function unescapeSegments(e){return e.replace(/__ESC_COLON_/gi,":")}function matchHas(e,t,r,n){void 0===r&&(r=[]),void 0===n&&(n=[]);let a={},hasMatch=r=>{let n;let o=r.key;switch(r.type){case"header":o=o.toLowerCase(),n=e.headers[o];break;case"cookie":if("cookies"in e)n=e.cookies[r.key];else{let t=(0,l.getCookieParser)(e.headers)();n=t[r.key]}break;case"query":n=t[o];break;case"host":{let{host:t}=(null==e?void 0:e.headers)||{},r=null==t?void 0:t.split(":")[0].toLowerCase();n=r}}if(!r.value&&n)return a[function(e){let t="";for(let r=0;r<e.length;r++){let n=e.charCodeAt(r);(n>64&&n<91||n>96&&n<123)&&(t+=e[r])}return t}(o)]=n,!0;if(n){let e=RegExp("^"+r.value+"$"),t=Array.isArray(n)?n.slice(-1)[0].match(e):n.match(e);if(t)return Array.isArray(t)&&(t.groups?Object.keys(t.groups).forEach(e=>{a[e]=t.groups[e]}):"host"===r.type&&t[0]&&(a.host=t[0])),!0}return!1},o=r.every(e=>hasMatch(e))&&!n.some(e=>hasMatch(e));return!!o&&a}function compileNonPath(e,t){if(!e.includes(":"))return e;for(let r of Object.keys(t))e.includes(":"+r)&&(e=e.replace(RegExp(":"+r+"\\*","g"),":"+r+"--ESCAPED_PARAM_ASTERISKS").replace(RegExp(":"+r+"\\?","g"),":"+r+"--ESCAPED_PARAM_QUESTION").replace(RegExp(":"+r+"\\+","g"),":"+r+"--ESCAPED_PARAM_PLUS").replace(RegExp(":"+r+"(?!\\w)","g"),"--ESCAPED_PARAM_COLON"+r));return e=e.replace(/(:|\*|\?|\+|\(|\)|\{|\})/g,"\\$1").replace(/--ESCAPED_PARAM_PLUS/g,"+").replace(/--ESCAPED_PARAM_COLON/g,":").replace(/--ESCAPED_PARAM_QUESTION/g,"?").replace(/--ESCAPED_PARAM_ASTERISKS/g,"*"),(0,n.compile)("/"+e,{validate:!1})(t).slice(1)}function prepareDestination(e){let t;let r=Object.assign({},e.query);delete r.__nextLocale,delete r.__nextDefaultLocale,delete r.__nextDataReq,delete r.__nextInferredLocaleFromDefault,delete r[s.NEXT_RSC_UNION_QUERY];let l=e.destination;for(let t of Object.keys({...e.params,...r}))l=l.replace(RegExp(":"+(0,a.escapeStringRegexp)(t),"g"),"__ESC_COLON_"+t);let u=(0,o.parseUrl)(l),c=u.query,d=unescapeSegments(""+u.pathname+(u.hash||"")),f=unescapeSegments(u.hostname||""),p=[],h=[];(0,n.pathToRegexp)(d,p),(0,n.pathToRegexp)(f,h);let m=[];p.forEach(e=>m.push(e.name)),h.forEach(e=>m.push(e.name));let g=(0,n.compile)(d,{validate:!1}),y=(0,n.compile)(f,{validate:!1});for(let[t,r]of Object.entries(c))Array.isArray(r)?c[t]=r.map(t=>compileNonPath(unescapeSegments(t),e.params)):"string"==typeof r&&(c[t]=compileNonPath(unescapeSegments(r),e.params));let v=Object.keys(e.params).filter(e=>"nextInternalLocale"!==e);if(e.appendParamsToQuery&&!v.some(e=>m.includes(e)))for(let t of v)t in c||(c[t]=e.params[t]);if((0,i.isInterceptionRouteAppPath)(d))for(let t of d.split("/")){let r=i.INTERCEPTION_ROUTE_MARKERS.find(e=>t.startsWith(e));if(r){e.params["0"]=r;break}}try{t=g(e.params);let[r,n]=t.split("#");u.hostname=y(e.params),u.pathname=r,u.hash=(n?"#":"")+(n||""),delete u.search}catch(e){if(e.message.match(/Expected .*? to not repeat, but got an array/))throw Error("To use a multi-match in the destination you must add `*` at the end of the param name to signify it should repeat. https://nextjs.org/docs/messages/invalid-multi-match");throw e}return u.query={...r,...u.query},{newUrl:t,destQuery:c,parsedDestination:u}}},57655:(e,t)=>{"use strict";function searchParamsToUrlQuery(e){let t={};return e.forEach((e,r)=>{void 0===t[r]?t[r]=e:Array.isArray(t[r])?t[r].push(e):t[r]=[t[r],e]}),t}function stringifyUrlQueryParam(e){return"string"!=typeof e&&("number"!=typeof e||isNaN(e))&&"boolean"!=typeof e?"":String(e)}function urlQueryToSearchParams(e){let t=new URLSearchParams;return Object.entries(e).forEach(e=>{let[r,n]=e;Array.isArray(n)?n.forEach(e=>t.append(r,stringifyUrlQueryParam(e))):t.set(r,stringifyUrlQueryParam(n))}),t}function assign(e){for(var t=arguments.length,r=Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];return r.forEach(t=>{Array.from(t.keys()).forEach(t=>e.delete(t)),t.forEach((t,r)=>e.append(r,t))}),e}Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{searchParamsToUrlQuery:function(){return searchParamsToUrlQuery},urlQueryToSearchParams:function(){return urlQueryToSearchParams},assign:function(){return assign}})},63049:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"removePathPrefix",{enumerable:!0,get:function(){return removePathPrefix}});let n=r(30619);function removePathPrefix(e,t){if(!(0,n.pathHasPrefix)(e,t))return e;let r=e.slice(t.length);return r.startsWith("/")?r:"/"+r}},84318:(e,t)=>{"use strict";function removeTrailingSlash(e){return e.replace(/\/$/,"")||"/"}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"removeTrailingSlash",{enumerable:!0,get:function(){return removeTrailingSlash}})},90133:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"default",{enumerable:!0,get:function(){return resolveRewrites}});let n=r(8673),a=r(55816),o=r(84318),i=r(73238),s=r(83698),l=r(40840);function resolveRewrites(e,t,r,u,c,d){let f,p=!1,h=!1,m=(0,l.parseRelativeUrl)(e),g=(0,o.removeTrailingSlash)((0,i.normalizeLocalePath)((0,s.removeBasePath)(m.pathname),d).pathname),handleRewrite=r=>{let l=(0,n.getPathMatch)(r.source+"(/)?",{removeUnnamedParams:!0,strict:!0}),y=l(m.pathname);if((r.has||r.missing)&&y){let e=(0,a.matchHas)({headers:{host:document.location.hostname,"user-agent":navigator.userAgent},cookies:document.cookie.split("; ").reduce((e,t)=>{let[r,...n]=t.split("=");return e[r]=n.join("="),e},{})},m.query,r.has,r.missing);e?Object.assign(y,e):y=!1}if(y){if(!r.destination)return h=!0,!0;let n=(0,a.prepareDestination)({appendParamsToQuery:!0,destination:r.destination,params:y,query:u});if(m=n.parsedDestination,e=n.newUrl,Object.assign(u,n.parsedDestination.query),g=(0,o.removeTrailingSlash)((0,i.normalizeLocalePath)((0,s.removeBasePath)(e),d).pathname),t.includes(g))return p=!0,f=g,!0;if((f=c(g))!==e&&t.includes(f))return p=!0,!0}},y=!1;for(let e=0;e<r.beforeFiles.length;e++)handleRewrite(r.beforeFiles[e]);if(!(p=t.includes(g))){if(!y){for(let e=0;e<r.afterFiles.length;e++)if(handleRewrite(r.afterFiles[e])){y=!0;break}}if(y||(f=c(g),y=p=t.includes(f)),!y){for(let e=0;e<r.fallback.length;e++)if(handleRewrite(r.fallback[e])){y=!0;break}}}return{asPath:e,parsedAs:m,matchedPage:p,resolvedHref:f,externalDest:h}}},1211:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getRouteMatcher",{enumerable:!0,get:function(){return getRouteMatcher}});let n=r(35504);function getRouteMatcher(e){let{re:t,groups:r}=e;return e=>{let a=t.exec(e);if(!a)return!1;let decode=e=>{try{return decodeURIComponent(e)}catch(e){throw new n.DecodeError("failed to decode param")}},o={};return Object.keys(r).forEach(e=>{let t=r[e],n=a[t.pos];void 0!==n&&(o[e]=~n.indexOf("/")?n.split("/").map(e=>decode(e)):t.repeat?[decode(n)]:decode(n))}),o}}},51076:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{getRouteRegex:function(){return getRouteRegex},getNamedRouteRegex:function(){return getNamedRouteRegex},getNamedMiddlewareRegex:function(){return getNamedMiddlewareRegex}});let n=r(92407),a=r(7983),o=r(84318);function parseParameter(e){let t=e.startsWith("[")&&e.endsWith("]");t&&(e=e.slice(1,-1));let r=e.startsWith("...");return r&&(e=e.slice(3)),{key:e,repeat:r,optional:t}}function getParametrizedRoute(e){let t=(0,o.removeTrailingSlash)(e).slice(1).split("/"),r={},i=1;return{parameterizedRoute:t.map(e=>{let t=n.INTERCEPTION_ROUTE_MARKERS.find(t=>e.startsWith(t)),o=e.match(/\[((?:\[.*\])|.+)\]/);if(t&&o){let{key:e,optional:n,repeat:s}=parseParameter(o[1]);return r[e]={pos:i++,repeat:s,optional:n},"/"+(0,a.escapeStringRegexp)(t)+"([^/]+?)"}if(!o)return"/"+(0,a.escapeStringRegexp)(e);{let{key:e,repeat:t,optional:n}=parseParameter(o[1]);return r[e]={pos:i++,repeat:t,optional:n},t?n?"(?:/(.+?))?":"/(.+?)":"/([^/]+?)"}}).join(""),groups:r}}function getRouteRegex(e){let{parameterizedRoute:t,groups:r}=getParametrizedRoute(e);return{re:RegExp("^"+t+"(?:/)?$"),groups:r}}function getSafeKeyFromSegment(e){let{getSafeRouteKey:t,segment:r,routeKeys:n,keyPrefix:a}=e,{key:o,optional:i,repeat:s}=parseParameter(r),l=o.replace(/\W/g,"");a&&(l=""+a+l);let u=!1;return(0===l.length||l.length>30)&&(u=!0),isNaN(parseInt(l.slice(0,1)))||(u=!0),u&&(l=t()),a?n[l]=""+a+o:n[l]=""+o,s?i?"(?:/(?<"+l+">.+?))?":"/(?<"+l+">.+?)":"/(?<"+l+">[^/]+?)"}function getNamedParametrizedRoute(e,t){let r;let i=(0,o.removeTrailingSlash)(e).slice(1).split("/"),s=(r=0,()=>{let e="",t=++r;for(;t>0;)e+=String.fromCharCode(97+(t-1)%26),t=Math.floor((t-1)/26);return e}),l={};return{namedParameterizedRoute:i.map(e=>{let r=n.INTERCEPTION_ROUTE_MARKERS.some(t=>e.startsWith(t)),o=e.match(/\[((?:\[.*\])|.+)\]/);return r&&o?getSafeKeyFromSegment({getSafeRouteKey:s,segment:o[1],routeKeys:l,keyPrefix:t?"nxtI":void 0}):o?getSafeKeyFromSegment({getSafeRouteKey:s,segment:o[1],routeKeys:l,keyPrefix:t?"nxtP":void 0}):"/"+(0,a.escapeStringRegexp)(e)}).join(""),routeKeys:l}}function getNamedRouteRegex(e,t){let r=getNamedParametrizedRoute(e,t);return{...getRouteRegex(e),namedRegex:"^"+r.namedParameterizedRoute+"(?:/)?$",routeKeys:r.routeKeys}}function getNamedMiddlewareRegex(e,t){let{parameterizedRoute:r}=getParametrizedRoute(e),{catchAll:n=!0}=t;if("/"===r)return{namedRegex:"^/"+(n?".*":"")+"$"};let{namedParameterizedRoute:a}=getNamedParametrizedRoute(e,!1);return{namedRegex:"^"+a+(n?"(?:(/.*)?)":"")+"$"}}},45906:(e,t)=>{"use strict";function isGroupSegment(e){return"("===e[0]&&e.endsWith(")")}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"isGroupSegment",{enumerable:!0,get:function(){return isGroupSegment}})},11010:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"default",{enumerable:!0,get:function(){return SideEffect}});let n=r(16689),useClientOnlyLayoutEffect=()=>{},useClientOnlyEffect=()=>{};function SideEffect(e){var t;let{headManager:r,reduceComponentsToState:a}=e;function emitChange(){if(r&&r.mountedInstances){let t=n.Children.toArray(Array.from(r.mountedInstances).filter(Boolean));r.updateHead(a(t,e))}}return null==r||null==(t=r.mountedInstances)||t.add(e.children),emitChange(),useClientOnlyLayoutEffect(()=>{var t;return null==r||null==(t=r.mountedInstances)||t.add(e.children),()=>{var t;null==r||null==(t=r.mountedInstances)||t.delete(e.children)}}),useClientOnlyLayoutEffect(()=>(r&&(r._pendingUpdate=emitChange),()=>{r&&(r._pendingUpdate=emitChange)})),useClientOnlyEffect(()=>(r&&r._pendingUpdate&&(r._pendingUpdate(),r._pendingUpdate=null),()=>{r&&r._pendingUpdate&&(r._pendingUpdate(),r._pendingUpdate=null)})),null}},74330:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"warnOnce",{enumerable:!0,get:function(){return warnOnce}});let warnOnce=e=>{}},20738:e=>{(()=>{"use strict";"undefined"!=typeof __nccwpck_require__&&(__nccwpck_require__.ab=__dirname+"/");var t={};(()=>{/*!
 * cookie
 * Copyright(c) 2012-2014 Roman Shtylman
 * Copyright(c) 2015 Douglas Christopher Wilson
 * MIT Licensed
 */t.parse=function(t,r){if("string"!=typeof t)throw TypeError("argument str must be a string");for(var a={},o=t.split(n),i=(r||{}).decode||e,s=0;s<o.length;s++){var l=o[s],u=l.indexOf("=");if(!(u<0)){var c=l.substr(0,u).trim(),d=l.substr(++u,l.length).trim();'"'==d[0]&&(d=d.slice(1,-1)),void 0==a[c]&&(a[c]=function(e,t){try{return t(e)}catch(t){return e}}(d,i))}}return a},t.serialize=function(e,t,n){var o=n||{},i=o.encode||r;if("function"!=typeof i)throw TypeError("option encode is invalid");if(!a.test(e))throw TypeError("argument name is invalid");var s=i(t);if(s&&!a.test(s))throw TypeError("argument val is invalid");var l=e+"="+s;if(null!=o.maxAge){var u=o.maxAge-0;if(isNaN(u)||!isFinite(u))throw TypeError("option maxAge is invalid");l+="; Max-Age="+Math.floor(u)}if(o.domain){if(!a.test(o.domain))throw TypeError("option domain is invalid");l+="; Domain="+o.domain}if(o.path){if(!a.test(o.path))throw TypeError("option path is invalid");l+="; Path="+o.path}if(o.expires){if("function"!=typeof o.expires.toUTCString)throw TypeError("option expires is invalid");l+="; Expires="+o.expires.toUTCString()}if(o.httpOnly&&(l+="; HttpOnly"),o.secure&&(l+="; Secure"),o.sameSite)switch("string"==typeof o.sameSite?o.sameSite.toLowerCase():o.sameSite){case!0:case"strict":l+="; SameSite=Strict";break;case"lax":l+="; SameSite=Lax";break;case"none":l+="; SameSite=None";break;default:throw TypeError("option sameSite is invalid")}return l};var e=decodeURIComponent,r=encodeURIComponent,n=/; */,a=/^[\u0009\u0020-\u007e\u0080-\u00ff]+$/})(),e.exports=t})()},51662:(e,t,r)=>{(()=>{var t={154:(e,t,r)=>{var n=r(781),a=["write","end","destroy"],o=["resume","pause"],i=["data","close"],s=Array.prototype.slice;function forEach(e,t){if(e.forEach)return e.forEach(t);for(var r=0;r<e.length;r++)t(e[r],r)}e.exports=function(e,t){var r=new n,l=!1;return forEach(a,function(t){r[t]=function(){return e[t].apply(e,arguments)}}),forEach(o,function(e){r[e]=function(){r.emit(e);var n=t[e];if(n)return n.apply(t,arguments);t.emit(e)}}),forEach(i,function(e){t.on(e,function(){var t=s.call(arguments);t.unshift(e),r.emit.apply(r,t)})}),t.on("end",function(){if(!l){l=!0;var e=s.call(arguments);e.unshift("end"),r.emit.apply(r,e)}}),e.on("drain",function(){r.emit("drain")}),e.on("error",reemit),t.on("error",reemit),r.writable=e.writable,r.readable=t.readable,r;function reemit(e){r.emit("error",e)}}},349:(e,t,r)=>{"use strict";let n=r(147),a=r(781),o=r(796),i=r(154),s=r(530),getOptions=e=>Object.assign({level:9},e);e.exports=(e,t)=>e?s(o.gzip)(e,getOptions(t)).then(e=>e.length).catch(e=>0):Promise.resolve(0),e.exports.sync=(e,t)=>o.gzipSync(e,getOptions(t)).length,e.exports.stream=e=>{let t=new a.PassThrough,r=new a.PassThrough,n=i(t,r),s=0,l=o.createGzip(getOptions(e)).on("data",e=>{s+=e.length}).on("error",()=>{n.gzipSize=0}).on("end",()=>{n.gzipSize=s,n.emit("gzip-size",s),r.end()});return t.pipe(l),t.pipe(r,{end:!1}),n},e.exports.file=(t,r)=>new Promise((a,o)=>{let i=n.createReadStream(t);i.on("error",o);let s=i.pipe(e.exports.stream(r));s.on("error",o),s.on("gzip-size",a)}),e.exports.fileSync=(t,r)=>e.exports.sync(n.readFileSync(t),r)},530:e=>{"use strict";let processFn=(e,t)=>function(...r){let n=t.promiseModule;return new n((n,a)=>{t.multiArgs?r.push((...e)=>{t.errorFirst?e[0]?a(e):(e.shift(),n(e)):n(e)}):t.errorFirst?r.push((e,t)=>{e?a(e):n(t)}):r.push(n),e.apply(this,r)})};e.exports=(e,t)=>{let r;t=Object.assign({exclude:[/.+(Sync|Stream)$/],errorFirst:!0,promiseModule:Promise},t);let n=typeof e;if(!(null!==e&&("object"===n||"function"===n)))throw TypeError(`Expected \`input\` to be a \`Function\` or \`Object\`, got \`${null===e?"null":n}\``);let filter=e=>{let match=t=>"string"==typeof t?e===t:t.test(e);return t.include?t.include.some(match):!t.exclude.some(match)};for(let a in r="function"===n?function(...r){return t.excludeMain?e(...r):processFn(e,t).apply(this,r)}:Object.create(Object.getPrototypeOf(e)),e){let n=e[a];r[a]="function"==typeof n&&filter(a)?processFn(n,t):n}return r}},147:e=>{"use strict";e.exports=r(57147)},781:e=>{"use strict";e.exports=r(12781)},796:e=>{"use strict";e.exports=r(59796)}},n={};function __nccwpck_require__(e){var r=n[e];if(void 0!==r)return r.exports;var a=n[e]={exports:{}},o=!0;try{t[e](a,a.exports,__nccwpck_require__),o=!1}finally{o&&delete n[e]}return a.exports}__nccwpck_require__.ab=__dirname+"/";var a=__nccwpck_require__(349);e.exports=a})()},74329:(e,t)=>{"use strict";function parse(e,t){void 0===t&&(t={});for(var r=function(e){for(var t=[],r=0;r<e.length;){var n=e[r];if("*"===n||"+"===n||"?"===n){t.push({type:"MODIFIER",index:r,value:e[r++]});continue}if("\\"===n){t.push({type:"ESCAPED_CHAR",index:r++,value:e[r++]});continue}if("{"===n){t.push({type:"OPEN",index:r,value:e[r++]});continue}if("}"===n){t.push({type:"CLOSE",index:r,value:e[r++]});continue}if(":"===n){for(var a="",o=r+1;o<e.length;){var i=e.charCodeAt(o);if(i>=48&&i<=57||i>=65&&i<=90||i>=97&&i<=122||95===i){a+=e[o++];continue}break}if(!a)throw TypeError("Missing parameter name at "+r);t.push({type:"NAME",index:r,value:a}),r=o;continue}if("("===n){var s=1,l="",o=r+1;if("?"===e[o])throw TypeError('Pattern cannot start with "?" at '+o);for(;o<e.length;){if("\\"===e[o]){l+=e[o++]+e[o++];continue}if(")"===e[o]){if(0==--s){o++;break}}else if("("===e[o]&&(s++,"?"!==e[o+1]))throw TypeError("Capturing groups are not allowed at "+o);l+=e[o++]}if(s)throw TypeError("Unbalanced pattern at "+r);if(!l)throw TypeError("Missing pattern at "+r);t.push({type:"PATTERN",index:r,value:l}),r=o;continue}t.push({type:"CHAR",index:r,value:e[r++]})}return t.push({type:"END",index:r,value:""}),t}(e),n=t.prefixes,a=void 0===n?"./":n,o="[^"+escapeString(t.delimiter||"/#?")+"]+?",i=[],s=0,l=0,u="",tryConsume=function(e){if(l<r.length&&r[l].type===e)return r[l++].value},mustConsume=function(e){var t=tryConsume(e);if(void 0!==t)return t;var n=r[l];throw TypeError("Unexpected "+n.type+" at "+n.index+", expected "+e)},consumeText=function(){for(var e,t="";e=tryConsume("CHAR")||tryConsume("ESCAPED_CHAR");)t+=e;return t};l<r.length;){var c=tryConsume("CHAR"),d=tryConsume("NAME"),f=tryConsume("PATTERN");if(d||f){var p=c||"";-1===a.indexOf(p)&&(u+=p,p=""),u&&(i.push(u),u=""),i.push({name:d||s++,prefix:p,suffix:"",pattern:f||o,modifier:tryConsume("MODIFIER")||""});continue}var h=c||tryConsume("ESCAPED_CHAR");if(h){u+=h;continue}if(u&&(i.push(u),u=""),tryConsume("OPEN")){var p=consumeText(),m=tryConsume("NAME")||"",g=tryConsume("PATTERN")||"",y=consumeText();mustConsume("CLOSE"),i.push({name:m||(g?s++:""),pattern:m&&!g?o:g,prefix:p,suffix:y,modifier:tryConsume("MODIFIER")||""});continue}mustConsume("END")}return i}function tokensToFunction(e,t){void 0===t&&(t={});var r=flags(t),n=t.encode,a=void 0===n?function(e){return e}:n,o=t.validate,i=void 0===o||o,s=e.map(function(e){if("object"==typeof e)return RegExp("^(?:"+e.pattern+")$",r)});return function(t){for(var r="",n=0;n<e.length;n++){var o=e[n];if("string"==typeof o){r+=o;continue}var l=t?t[o.name]:void 0,u="?"===o.modifier||"*"===o.modifier,c="*"===o.modifier||"+"===o.modifier;if(Array.isArray(l)){if(!c)throw TypeError('Expected "'+o.name+'" to not repeat, but got an array');if(0===l.length){if(u)continue;throw TypeError('Expected "'+o.name+'" to not be empty')}for(var d=0;d<l.length;d++){var f=a(l[d],o);if(i&&!s[n].test(f))throw TypeError('Expected all "'+o.name+'" to match "'+o.pattern+'", but got "'+f+'"');r+=o.prefix+f+o.suffix}continue}if("string"==typeof l||"number"==typeof l){var f=a(String(l),o);if(i&&!s[n].test(f))throw TypeError('Expected "'+o.name+'" to match "'+o.pattern+'", but got "'+f+'"');r+=o.prefix+f+o.suffix;continue}if(!u){var p=c?"an array":"a string";throw TypeError('Expected "'+o.name+'" to be '+p)}}return r}}function regexpToFunction(e,t,r){void 0===r&&(r={});var n=r.decode,a=void 0===n?function(e){return e}:n;return function(r){var n=e.exec(r);if(!n)return!1;for(var o=n[0],i=n.index,s=Object.create(null),l=1;l<n.length;l++)!function(e){if(void 0!==n[e]){var r=t[e-1];"*"===r.modifier||"+"===r.modifier?s[r.name]=n[e].split(r.prefix+r.suffix).map(function(e){return a(e,r)}):s[r.name]=a(n[e],r)}}(l);return{path:o,index:i,params:s}}}function escapeString(e){return e.replace(/([.+*?=^!:${}()[\]|/\\])/g,"\\$1")}function flags(e){return e&&e.sensitive?"":"i"}function tokensToRegexp(e,t,r){void 0===r&&(r={});for(var n=r.strict,a=void 0!==n&&n,o=r.start,i=r.end,s=r.encode,l=void 0===s?function(e){return e}:s,u="["+escapeString(r.endsWith||"")+"]|$",c="["+escapeString(r.delimiter||"/#?")+"]",d=void 0===o||o?"^":"",f=0;f<e.length;f++){var p=e[f];if("string"==typeof p)d+=escapeString(l(p));else{var h=escapeString(l(p.prefix)),m=escapeString(l(p.suffix));if(p.pattern){if(t&&t.push(p),h||m){if("+"===p.modifier||"*"===p.modifier){var g="*"===p.modifier?"?":"";d+="(?:"+h+"((?:"+p.pattern+")(?:"+m+h+"(?:"+p.pattern+"))*)"+m+")"+g}else d+="(?:"+h+"("+p.pattern+")"+m+")"+p.modifier}else d+="("+p.pattern+")"+p.modifier}else d+="(?:"+h+m+")"+p.modifier}}if(void 0===i||i)a||(d+=c+"?"),d+=r.endsWith?"(?="+u+")":"$";else{var y=e[e.length-1],v="string"==typeof y?c.indexOf(y[y.length-1])>-1:void 0===y;a||(d+="(?:"+c+"(?="+u+"))?"),v||(d+="(?="+c+"|"+u+")")}return new RegExp(d,flags(r))}function pathToRegexp(e,t,r){return e instanceof RegExp?function(e,t){if(!t)return e;var r=e.source.match(/\((?!\?)/g);if(r)for(var n=0;n<r.length;n++)t.push({name:n,prefix:"",suffix:"",modifier:"",pattern:""});return e}(e,t):Array.isArray(e)?RegExp("(?:"+e.map(function(e){return pathToRegexp(e,t,r).source}).join("|")+")",flags(r)):tokensToRegexp(parse(e,r),t,r)}Object.defineProperty(t,"__esModule",{value:!0}),t.parse=parse,t.compile=function(e,t){return tokensToFunction(parse(e,t),t)},t.tokensToFunction=tokensToFunction,t.match=function(e,t){var r=[];return regexpToFunction(pathToRegexp(e,r,t),r,t)},t.regexpToFunction=regexpToFunction,t.tokensToRegexp=tokensToRegexp,t.pathToRegexp=pathToRegexp},79423:(e,t)=>{"use strict";function isAPIRoute(e){return"/api"===e||!!(null==e?void 0:e.startsWith("/api/"))}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"isAPIRoute",{enumerable:!0,get:function(){return isAPIRoute}})},11730:(e,t,r)=>{"use strict";function getCookieParser(e){return function(){let{cookie:t}=e;if(!t)return{};let{parse:n}=r(20738);return n(Array.isArray(t)?t.join("; "):t)}}Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"getCookieParser",{enumerable:!0,get:function(){return getCookieParser}})},92407:(e,t,r)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),function(e,t){for(var r in t)Object.defineProperty(e,r,{enumerable:!0,get:t[r]})}(t,{INTERCEPTION_ROUTE_MARKERS:function(){return a},isInterceptionRouteAppPath:function(){return isInterceptionRouteAppPath},extractInterceptionRouteInformation:function(){return extractInterceptionRouteInformation}});let n=r(11418),a=["(..)(..)","(.)","(..)","(...)"];function isInterceptionRouteAppPath(e){return void 0!==e.split("/").find(e=>a.find(t=>e.startsWith(t)))}function extractInterceptionRouteInformation(e){let t,r,o;for(let n of e.split("/"))if(r=a.find(e=>n.startsWith(e))){[t,o]=e.split(r,2);break}if(!t||!r||!o)throw Error(`Invalid interception route: ${e}. Must be in the format /<intercepting route>/(..|...|..)(..)/<intercepted route>`);switch(t=(0,n.normalizeAppPath)(t),r){case"(.)":o="/"===t?`/${o}`:t+"/"+o;break;case"(..)":if("/"===t)throw Error(`Invalid interception route: ${e}. Cannot use (..) marker at the root level, use (.) instead.`);o=t.split("/").slice(0,-1).concat(o).join("/");break;case"(...)":o="/"+o;break;case"(..)(..)":let i=t.split("/");if(i.length<=2)throw Error(`Invalid interception route: ${e}. Cannot use (..)(..) marker at the root level or one level up.`);o=i.slice(0,-2).concat(o).join("/");break;default:throw Error("Invariant: unexpected marker")}return{interceptingRoute:t,interceptedRoute:o}}},98039:(e,t,r)=>{"use strict";e.exports=r(87093).vendored.contexts.AmpContext},7443:(e,t,r)=>{"use strict";e.exports=r(87093).vendored.contexts.AppRouterContext},41988:(e,t,r)=>{"use strict";e.exports=r(87093).vendored.contexts.HeadManagerContext},16218:(e,t,r)=>{"use strict";e.exports=r(87093).vendored.contexts.ImageConfigContext},74830:(e,t,r)=>{"use strict";e.exports=r(87093).vendored.contexts.Loadable},5469:(e,t,r)=>{"use strict";e.exports=r(87093).vendored.contexts.RouterContext},5152:(e,t,r)=>{e.exports=r(68563)},25675:(e,t,r)=>{e.exports=r(73164)},41664:(e,t,r)=>{e.exports=r(49961)},11163:(e,t,r)=>{e.exports=r(404)},28760:(e,t)=>{"use strict";function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,r=new WeakMap;return(_getRequireWildcardCache=function(e){return e?r:t})(e)}t._=t._interop_require_wildcard=function(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var r=_getRequireWildcardCache(t);if(r&&r.has(e))return r.get(e);var n={},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var i=a?Object.getOwnPropertyDescriptor(e,o):null;i&&(i.get||i.set)?Object.defineProperty(n,o,i):n[o]=e[o]}return n.default=e,r&&r.set(e,n),n}}};
//# sourceMappingURL=556.js.map