/* eslint-disable @typescript-eslint/no-var-requires */
const withBundleAnalyzer = require('@next/bundle-analyzer')({
  enabled: process.env.ANALYZE === 'true',
})
// Next.js 13+ has built-in transpilation support, no need for next-transpile-modules

const { withSentryConfig } = require('@sentry/nextjs')

const sentryWebpackPluginOptions = {
  silent: true, // Suppresses all logs
  dryRun: !process.env.SENTRY_AUTH_TOKEN,
  hideSourceMaps: true,
}

/** @type {import('next').NextConfig} */
const config = {
  devIndicators: {
    buildActivity: false
  },
  images: {
    unoptimized: true,
  },
  typescript: {
    // !! WARN !!
    // Dangerously allow production builds to successfully complete even if
    // your project has type errors.
    // !! WARN !!
    ignoreBuildErrors: true,
  },
  compiler: {
    styledComponents: true,
  },
  // Next.js 13+ built-in transpilation for node_modules
  transpilePackages: ['@pancakeswap/uikit', '@pancakeswap/sdk', '@uniswap/token-lists'],
  experimental: {
    scrollRestoration: true,
  },
  trailingSlash: true,
  reactStrictMode: true,
  swcMinify: true, // Default in Next.js 13+
  webpack: (config, { isServer }) => {
    // Resolve @uniswap/token-lists to its source files since dist folder is missing
    config.resolve.alias = {
      ...config.resolve.alias,
      '@uniswap/token-lists': require.resolve('@uniswap/token-lists/src/index.ts'),
    }
    
    return config
  },
  async rewrites() {
    return [
      {
        source: '/info/token/:address',
        destination: '/info/tokens/:address',
      },
      {
        source: '/info/pool/:address',
        destination: '/info/pools/:address',
      },
      {
        source: '/info/pair/:address',
        destination: '/info/pools/:address',
      },
    ]
  },
  async headers() {
    return [
      {
        source: '/logo.png',
        headers: [
          {
            key: 'Cache-Control',
            value: 'public, immutable, max-age=31536000',
          },
        ],
      },
      {
        source: '/images/:all*',
        headers: [
          {
            key: 'Cache-Control',
            value: 'public, immutable, max-age=31536000',
          },
        ],
      },
      {
        source: '/images/tokens/:all*',
        headers: [
          {
            key: 'Cache-Control',
            value: 'public, immutable, max-age=604800',
          },
        ],
      },
    ]
  },
  async redirects() {
    return [
      {
        source: '/send',
        destination: '/swap',
        permanent: true,
      },
      {
        source: '/:outputCurrency',
        destination: '/?outputCurrency=:outputCurrency',
        permanent: true,
      },
      {
        source: '/create/:currency*',
        destination: '/add/:currency*',
        permanent: true,
      },
      {
        source: '/farms/archived',
        destination: '/farms/history',
        permanent: true,
      },
      {
        source: '/pool',
        destination: '/liquidity',
        permanent: true,
      },
      {
        source: '/staking',
        destination: '/pools',
        permanent: true,
      },
      {
        source: '/syrup',
        destination: '/pools',
        permanent: true,
      },
      {
        source: '/collectibles',
        destination: '/nfts',
        permanent: true,
      },
    ]
  }
}

module.exports = withBundleAnalyzer(withSentryConfig(config, sentryWebpackPluginOptions))
